/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.json.jackson.util;

import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JSONBuilder {
    private static final ObjectMapper OBJECT_MAPPER = (ObjectMapper)SpringUtil.getBean(ObjectMapper.class);
    private final ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();

    private JSONBuilder() {
    }

    public static JSONBuilder builder() {
        return new JSONBuilder();
    }

    public JSONBuilder add(String key, String value) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        if (value != null) {
            this.rootNode.put(key, value);
        }
        return this;
    }

    public JSONBuilder add(String key, int value) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        this.rootNode.put(key, value);
        return this;
    }

    public JSONBuilder add(String key, long value) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        this.rootNode.put(key, value);
        return this;
    }

    public JSONBuilder add(String key, boolean value) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        this.rootNode.put(key, value);
        return this;
    }

    public JSONBuilder add(String key, double value) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        this.rootNode.put(key, value);
        return this;
    }

    public JSONBuilder add(String key, JsonNode value) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        if (value != null) {
            this.rootNode.set(key, value);
        }
        return this;
    }

    public JSONBuilder add(String key, Object value) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        if (value != null) {
            this.rootNode.set(key, OBJECT_MAPPER.valueToTree(value));
        }
        return this;
    }

    public JSONBuilder add(String key, List<?> list) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        if (list != null) {
            ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
            for (Object item : list) {
                arrayNode.add(OBJECT_MAPPER.valueToTree(item));
            }
            this.rootNode.set(key, (JsonNode)arrayNode);
        }
        return this;
    }

    public JSONBuilder add(String key, Map<?, ?> map) {
        Objects.requireNonNull(key, "\u952e\u4e0d\u80fd\u4e3a null");
        if (map != null) {
            ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.valueToTree(map);
            this.rootNode.set(key, (JsonNode)objectNode);
        }
        return this;
    }

    public JsonNode build() {
        return this.rootNode;
    }

    public String buildString() {
        try {
            return this.rootNode.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6784\u5efa JSON \u5b57\u7b26\u4e32\u5931\u8d25", e);
        }
    }
}

