/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.json.jackson.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    private static final ObjectMapper OBJECT_MAPPER = (ObjectMapper)SpringUtil.getBean(ObjectMapper.class);

    private JSONUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static String toJsonStr(Object object) {
        if (ObjectUtil.isNull((Object)object)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.valueToTree(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonNode listToJson(List<?> list) {
        return JSONUtils.toJson(list);
    }

    public static JsonNode mapToJson(Map<?, ?> map) {
        return JSONUtils.toJson(map);
    }

    public static List<String> jsonToEnvList(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            return new ArrayList<String>();
        }
        ArrayList<String> envList = new ArrayList<String>();
        jsonNode.fields().forEachRemaining(field -> {
            String key = (String)field.getKey();
            JsonNode valueNode = (JsonNode)field.getValue();
            String value = valueNode.isValueNode() ? valueNode.asText() : valueNode.toString();
            envList.add(key + "=" + value);
        });
        return envList;
    }

    public static List<String> jsonToStringList(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            return new ArrayList<String>();
        }
        try {
            return (List)OBJECT_MAPPER.convertValue((Object)jsonNode, (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String str, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(str, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseArray(String str, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return new ArrayList();
        }
        try {
            return (List)OBJECT_MAPPER.readValue(str, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isTypeJSON(String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return false;
        }
        try {
            OBJECT_MAPPER.readTree(str);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static <T> T toBean(String str, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(str, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

