/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.log.handler;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.log.annotation.Log;
import top.continew.starter.log.enums.Include;
import top.continew.starter.log.handler.LogHandler;
import top.continew.starter.log.model.AccessLogContext;
import top.continew.starter.log.model.AccessLogProperties;
import top.continew.starter.log.model.LogRecord;
import top.continew.starter.log.util.AccessLogUtils;
import top.continew.starter.web.util.ServletUtils;

public abstract class AbstractLogHandler
implements LogHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogHandler.class);
    private final TransmittableThreadLocal<AccessLogContext> logContextThread = new TransmittableThreadLocal();

    @Override
    public boolean isRecord(Method targetMethod, Class<?> targetClass) {
        Operation methodOperation = (Operation)AnnotationUtil.getAnnotation((AnnotatedElement)targetMethod, Operation.class);
        if (methodOperation != null && methodOperation.hidden()) {
            return false;
        }
        Hidden methodHidden = (Hidden)AnnotationUtil.getAnnotation((AnnotatedElement)targetMethod, Hidden.class);
        if (methodHidden != null) {
            return false;
        }
        if (targetClass.getDeclaredAnnotation(Hidden.class) != null) {
            return false;
        }
        Log methodLog = (Log)AnnotationUtil.getAnnotation((AnnotatedElement)targetMethod, Log.class);
        if (methodLog != null && methodLog.ignore()) {
            return false;
        }
        Log classLog = (Log)AnnotationUtil.getAnnotation(targetClass, Log.class);
        return null == classLog || !classLog.ignore();
    }

    @Override
    public LogRecord.Started start(Instant startTime) {
        return LogRecord.start(startTime);
    }

    @Override
    public LogRecord finish(LogRecord.Started started, Instant endTime, Set<Include> includes, Method targetMethod, Class<?> targetClass) {
        Set<Include> includeSet = this.getIncludes(includes, targetMethod, targetClass);
        LogRecord logRecord = this.finish(started, endTime, includeSet);
        if (includeSet.contains((Object)Include.DESCRIPTION)) {
            this.logDescription(logRecord, targetMethod);
        }
        if (includeSet.contains((Object)Include.MODULE)) {
            this.logModule(logRecord, targetMethod, targetClass);
        }
        return logRecord;
    }

    @Override
    public LogRecord finish(LogRecord.Started started, Instant endTime, Set<Include> includes) {
        return started.finish(endTime, includes);
    }

    @Override
    public void logDescription(LogRecord logRecord, Method targetMethod) {
        logRecord.setDescription("\u8bf7\u5728\u8be5\u63a5\u53e3\u65b9\u6cd5\u4e0a\u6dfb\u52a0 @top.continew.starter.log.annotation.Log(value) \u6765\u6307\u5b9a\u65e5\u5fd7\u63cf\u8ff0");
        Log methodLog = (Log)AnnotationUtil.getAnnotation((AnnotatedElement)targetMethod, Log.class);
        if (methodLog != null && CharSequenceUtil.isNotBlank((CharSequence)methodLog.value())) {
            logRecord.setDescription(methodLog.value());
            return;
        }
        Operation methodOperation = (Operation)AnnotationUtil.getAnnotation((AnnotatedElement)targetMethod, Operation.class);
        if (methodOperation != null && CharSequenceUtil.isNotBlank((CharSequence)methodOperation.summary())) {
            logRecord.setDescription(methodOperation.summary());
        }
    }

    @Override
    public void logModule(LogRecord logRecord, Method targetMethod, Class<?> targetClass) {
        logRecord.setModule("\u8bf7\u5728\u8be5\u63a5\u53e3\u65b9\u6cd5\u6216\u7c7b\u4e0a\u6dfb\u52a0 @top.continew.starter.log.annotation.Log(module) \u6765\u6307\u5b9a\u6240\u5c5e\u6a21\u5757");
        Log methodLog = (Log)AnnotationUtil.getAnnotation((AnnotatedElement)targetMethod, Log.class);
        if (methodLog != null && CharSequenceUtil.isNotBlank((CharSequence)methodLog.module())) {
            logRecord.setModule(methodLog.module());
            return;
        }
        Log classLog = (Log)AnnotationUtil.getAnnotation(targetClass, Log.class);
        if (classLog != null && CharSequenceUtil.isNotBlank((CharSequence)classLog.module())) {
            logRecord.setModule(classLog.module());
            return;
        }
        Tag classTag = (Tag)AnnotationUtil.getAnnotation(targetClass, Tag.class);
        if (classTag != null && CharSequenceUtil.isNotBlank((CharSequence)classTag.name())) {
            logRecord.setModule(classTag.name());
        }
    }

    @Override
    public Set<Include> getIncludes(Set<Include> includes, Method targetMethod, Class<?> targetClass) {
        Log methodLog;
        Log classLog = (Log)AnnotationUtil.getAnnotation(targetClass, Log.class);
        HashSet<Include> includeSet = new HashSet<Include>(includes);
        if (classLog != null) {
            this.processInclude(includeSet, classLog);
        }
        if ((methodLog = (Log)AnnotationUtil.getAnnotation((AnnotatedElement)targetMethod, Log.class)) != null) {
            this.processInclude(includeSet, methodLog);
        }
        return includeSet;
    }

    private void processInclude(Set<Include> includes, Log logAnnotation) {
        Include[] excludeArr;
        Include[] includeArr = logAnnotation.includes();
        if (includeArr.length > 0) {
            includes.addAll(Set.of(includeArr));
        }
        if ((excludeArr = logAnnotation.excludes()).length > 0) {
            includes.removeAll(Set.of(excludeArr));
        }
    }

    @Override
    public void accessLogStart(AccessLogContext accessLogContext) {
        AccessLogProperties properties = accessLogContext.getProperties().getAccessLog();
        if (!properties.isEnabled() || AccessLogUtils.exclusionPath(accessLogContext.getProperties(), ServletUtils.getRequestPath())) {
            return;
        }
        this.logContextThread.set((Object)accessLogContext);
        String param = AccessLogUtils.getParam(properties);
        log.info(param != null ? "[Start] [{}] {} param: {}" : "[Start] [{}] {}", new Object[]{ServletUtils.getRequestMethod(), ServletUtils.getRequestPath(), param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accessLogFinish(AccessLogContext accessLogContext) {
        AccessLogContext logContext = (AccessLogContext)this.logContextThread.get();
        if (ObjectUtil.isEmpty((Object)logContext)) {
            return;
        }
        try {
            Duration timeTaken = Duration.between(logContext.getStartTime(), accessLogContext.getEndTime());
            log.info("[End] [{}] {} {} {}ms", new Object[]{ServletUtils.getRequestMethod(), ServletUtils.getRequestPath(), ServletUtils.getResponseStatus(), timeTaken.toMillis()});
        }
        finally {
            this.logContextThread.remove();
        }
    }
}

