/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.log.model;

import java.time.Instant;
import top.continew.starter.log.model.LogProperties;

public class AccessLogContext {
    private final Instant startTime;
    private Instant endTime;
    private final LogProperties properties;

    private AccessLogContext(Builder builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.properties = builder.properties;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public LogProperties getProperties() {
        return this.properties;
    }

    public void setEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Instant startTime;
        private Instant endTime;
        private LogProperties properties;

        private Builder() {
        }

        public Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder properties(LogProperties properties) {
            this.properties = properties;
            return this;
        }

        public AccessLogContext build() {
            return new AccessLogContext(this);
        }
    }
}

