/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.log.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import top.continew.starter.log.enums.Include;
import top.continew.starter.log.model.AccessLogProperties;
import top.continew.starter.web.util.SpringWebUtils;

@ConfigurationProperties(value="continew-starter.log")
public class LogProperties {
    private boolean enabled = true;
    @NestedConfigurationProperty
    private AccessLogProperties accessLog = new AccessLogProperties();
    private Set<Include> includes = Include.defaultIncludes();
    private List<String> excludePatterns = new ArrayList<String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<Include> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<Include> includes) {
        this.includes = includes;
    }

    public List<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(List<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public AccessLogProperties getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(AccessLogProperties accessLog) {
        this.accessLog = accessLog;
    }

    public boolean isMatch(String uri) {
        return this.getExcludePatterns().stream().anyMatch(pattern -> SpringWebUtils.isMatch((String)uri, (String)pattern));
    }
}

