/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.log.model;

import cn.hutool.core.text.CharSequenceUtil;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import top.continew.starter.core.util.ExceptionUtils;
import top.continew.starter.core.util.IpUtils;
import top.continew.starter.log.enums.Include;
import top.continew.starter.web.util.ServletUtils;

public class LogRequest {
    private String method = ServletUtils.getRequestMethod();
    private URI url = ServletUtils.getRequestUrl();
    private String ip = ServletUtils.getRequestIp();
    private Map<String, String> headers;
    private String body;
    private Map<String, Object> param;
    private String address;
    private String browser;
    private String os;

    public LogRequest(Set<Include> includes) {
        Map map = this.headers = includes.contains((Object)Include.REQUEST_HEADERS) ? ServletUtils.getRequestHeaders() : null;
        if (includes.contains((Object)Include.REQUEST_BODY)) {
            this.body = ServletUtils.getRequestBody();
        } else if (includes.contains((Object)Include.REQUEST_PARAM)) {
            this.param = ServletUtils.getRequestParams();
        }
        String string = this.address = includes.contains((Object)Include.IP_ADDRESS) ? (String)ExceptionUtils.exToNull(() -> IpUtils.getIpv4Address((String)this.ip)) : null;
        if (null == this.headers) {
            return;
        }
        String userAgentString = this.headers.entrySet().stream().filter(h -> "User-Agent".equalsIgnoreCase((String)h.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
        if (CharSequenceUtil.isNotBlank((CharSequence)userAgentString)) {
            this.browser = includes.contains((Object)Include.BROWSER) ? ServletUtils.getBrowser((String)userAgentString) : null;
            this.os = includes.contains((Object)Include.OS) ? ServletUtils.getOs((String)userAgentString) : null;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }
}

