/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.ratelimiter.aop;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateLimiterConfig;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import top.continew.starter.cache.redisson.util.RedisUtils;
import top.continew.starter.core.util.expression.ExpressionUtils;
import top.continew.starter.ratelimiter.annotation.RateLimiter;
import top.continew.starter.ratelimiter.annotation.RateLimiters;
import top.continew.starter.ratelimiter.autoconfigure.RateLimiterProperties;
import top.continew.starter.ratelimiter.enums.LimitType;
import top.continew.starter.ratelimiter.exception.RateLimiterException;
import top.continew.starter.ratelimiter.generator.RateLimiterNameGenerator;
import top.continew.starter.web.util.ServletUtils;

@Aspect
public class RateLimiterAspect {
    private static final ConcurrentHashMap<String, RRateLimiter> RATE_LIMITER_CACHE = new ConcurrentHashMap();
    private final RateLimiterProperties properties;
    private final RateLimiterNameGenerator nameGenerator;
    private final RedissonClient redissonClient;

    public RateLimiterAspect(RateLimiterProperties properties, RateLimiterNameGenerator nameGenerator, RedissonClient redissonClient) {
        this.properties = properties;
        this.nameGenerator = nameGenerator;
        this.redissonClient = redissonClient;
    }

    @Pointcut(value="@annotation(top.continew.starter.ratelimiter.annotation.RateLimiter)")
    public void rateLimiterPointCut() {
    }

    @Pointcut(value="@annotation(top.continew.starter.ratelimiter.annotation.RateLimiters)")
    public void rateLimitersPointCut() {
    }

    @Around(value="@annotation(rateLimiter)")
    public Object aroundRateLimiter(ProceedingJoinPoint joinPoint, RateLimiter rateLimiter) throws Throwable {
        if (this.isRateLimited(joinPoint, rateLimiter)) {
            throw new RateLimiterException(rateLimiter.message());
        }
        return joinPoint.proceed();
    }

    @Around(value="@annotation(rateLimiters)")
    public Object aroundRateLimiters(ProceedingJoinPoint joinPoint, RateLimiters rateLimiters) throws Throwable {
        for (RateLimiter rateLimiter : rateLimiters.value()) {
            if (!this.isRateLimited(joinPoint, rateLimiter)) continue;
            throw new RateLimiterException(rateLimiter.message());
        }
        return joinPoint.proceed();
    }

    private boolean isRateLimited(ProceedingJoinPoint joinPoint, RateLimiter rateLimiter) {
        try {
            String cacheKey = this.getCacheKey((JoinPoint)joinPoint, rateLimiter);
            RRateLimiter rRateLimiter = RATE_LIMITER_CACHE.computeIfAbsent(cacheKey, key -> this.redissonClient.getRateLimiter(cacheKey));
            RateType rateType = rateLimiter.type() == LimitType.CLUSTER ? RateType.PER_CLIENT : RateType.OVERALL;
            int rate = rateLimiter.rate();
            Duration rateInterval = Duration.ofMillis(rateLimiter.unit().toMillis(rateLimiter.interval()));
            if (this.isConfigurationUpdateNeeded(rRateLimiter, rateType, rate, rateInterval)) {
                rRateLimiter.setRate(rateType, (long)rate, rateInterval);
            }
            return !rRateLimiter.tryAcquire();
        }
        catch (Exception e) {
            throw new RateLimiterException("\u670d\u52a1\u5668\u9650\u6d41\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", e);
        }
    }

    private String getCacheKey(JoinPoint joinPoint, RateLimiter rateLimiter) {
        String key;
        Object target = joinPoint.getTarget();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object[] args = joinPoint.getArgs();
        String name = rateLimiter.name();
        if (CharSequenceUtil.isBlank((CharSequence)name)) {
            name = this.nameGenerator.generate(target, method, args);
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)(key = rateLimiter.key()))) {
            Object eval = ExpressionUtils.eval((String)key, (Object)target, (Method)method, (Object[])args);
            if (ObjectUtil.isNull((Object)eval)) {
                throw new RateLimiterException("\u9650\u6d41 Key \u89e3\u6790\u9519\u8bef");
            }
            key = Convert.toStr((Object)eval);
        }
        String suffix = switch (rateLimiter.type()) {
            case LimitType.IP -> ServletUtils.getRequestIp();
            case LimitType.CLUSTER -> this.redissonClient.getId();
            default -> "";
        };
        return RedisUtils.formatKey((String[])new String[]{this.properties.getKeyPrefix(), name, key, suffix});
    }

    private boolean isConfigurationUpdateNeeded(RRateLimiter rRateLimiter, RateType rateType, long rate, Duration rateInterval) {
        RateLimiterConfig config = rRateLimiter.getConfig();
        return !Objects.equals(config.getRateType(), rateType) || !Objects.equals(config.getRate(), rate) || !Objects.equals(config.getRateInterval(), rateInterval.toMillis());
    }
}

