/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.type.SimpleTypeRegistry;
import top.continew.starter.security.crypto.annotation.FieldEncrypt;
import top.continew.starter.security.crypto.autoconfigure.CryptoProperties;
import top.continew.starter.security.crypto.core.AbstractMyBatisInterceptor;
import top.continew.starter.security.crypto.encryptor.IEncryptor;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class MyBatisDecryptInterceptor
extends AbstractMyBatisInterceptor
implements Interceptor {
    private CryptoProperties properties;

    public MyBatisDecryptInterceptor(CryptoProperties properties) {
        this.properties = properties;
    }

    public MyBatisDecryptInterceptor() {
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object obj = invocation.proceed();
        if (null == obj || !(invocation.getTarget() instanceof ResultSetHandler)) {
            return obj;
        }
        List resultList = (List)obj;
        for (Object result : resultList) {
            if (SimpleTypeRegistry.isSimpleType(result.getClass())) continue;
            List<Field> fieldList = super.getEncryptFields(result);
            for (Field field : fieldList) {
                IEncryptor encryptor = super.getEncryptor(field.getAnnotation(FieldEncrypt.class));
                Object fieldValue = ReflectUtil.getFieldValue(result, (Field)field);
                if (null == fieldValue) continue;
                String password = (String)ObjectUtil.defaultIfBlank((CharSequence)field.getAnnotation(FieldEncrypt.class).password(), (CharSequence)this.properties.getPassword());
                String ciphertext = encryptor.decrypt(fieldValue.toString(), password, this.properties.getPrivateKey());
                ReflectUtil.setFieldValue(result, (Field)field, (Object)ciphertext);
            }
        }
        return resultList;
    }
}

