/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.core;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import top.continew.starter.core.exception.BaseException;
import top.continew.starter.security.crypto.annotation.FieldEncrypt;
import top.continew.starter.security.crypto.autoconfigure.CryptoProperties;
import top.continew.starter.security.crypto.core.AbstractMyBatisInterceptor;
import top.continew.starter.security.crypto.encryptor.IEncryptor;

public class MyBatisEncryptInterceptor
extends AbstractMyBatisInterceptor
implements InnerInterceptor {
    private static final Pattern PARAM_PAIRS_PATTERN = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)\\}");
    private final CryptoProperties properties;

    public MyBatisEncryptInterceptor(CryptoProperties properties) {
        this.properties = properties;
    }

    public void beforeQuery(Executor executor, MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (null == parameterObject) {
            return;
        }
        if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            this.encryptQueryParameter(parameterMap, mappedStatement);
        }
    }

    public void beforeUpdate(Executor executor, MappedStatement mappedStatement, Object parameterObject) {
        if (null == parameterObject) {
            return;
        }
        if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            this.encryptMap(parameterMap, mappedStatement);
        } else {
            this.encryptEntity(super.getEncryptFields(parameterObject), parameterObject);
        }
    }

    private void encryptMap(Map<String, Object> parameterMap, MappedStatement mappedStatement) {
        Object parameter;
        if (parameterMap.containsKey("et") && (parameter = parameterMap.get("et")) != null) {
            this.encryptEntity(super.getEncryptFields(parameter), parameter);
        }
        if (parameterMap.containsKey("ew") && (parameter = parameterMap.get("ew")) != null) {
            this.encryptUpdateWrapper(parameter, mappedStatement);
        }
    }

    private void encryptQueryParameter(Map<String, Object> parameterMap, MappedStatement mappedStatement) {
        Map<String, FieldEncrypt> encryptParameterMap = super.getEncryptParameters(mappedStatement);
        for (Map.Entry<String, Object> parameterEntrySet : parameterMap.entrySet()) {
            String parameterName = parameterEntrySet.getKey();
            Object parameterValue = parameterEntrySet.getValue();
            if (null == parameterValue || ClassUtil.isBasicType(parameterValue.getClass()) || parameterValue instanceof AbstractWrapper) continue;
            if (parameterValue instanceof String) {
                String str = (String)parameterValue;
                FieldEncrypt fieldEncrypt = encryptParameterMap.get(parameterName);
                if (fieldEncrypt == null) continue;
                parameterMap.put(parameterName, this.doEncrypt(str, fieldEncrypt));
                continue;
            }
            this.encryptEntity(super.getEncryptFields(parameterValue), parameterValue);
        }
    }

    private void encryptUpdateWrapper(Object parameter, MappedStatement mappedStatement) {
        if (parameter instanceof AbstractWrapper) {
            AbstractWrapper updateWrapper = (AbstractWrapper)parameter;
            String sqlSet = updateWrapper.getSqlSet();
            if (CharSequenceUtil.isBlank((CharSequence)sqlSet)) {
                return;
            }
            String[] elArr = sqlSet.split(",");
            HashMap propMap = new HashMap(elArr.length);
            Arrays.stream(elArr).forEach(el -> {
                String[] elPart = el.split("=");
                propMap.put(elPart[0], elPart[1]);
            });
            Class entityClass = mappedStatement.getParameterMap().getType();
            List<Field> encryptFieldList = super.getEncryptFields(entityClass);
            for (Field field : encryptFieldList) {
                Matcher matcher;
                FieldEncrypt fieldEncrypt = field.getAnnotation(FieldEncrypt.class);
                String el2 = (String)propMap.get(field.getName());
                if (CharSequenceUtil.isBlank((CharSequence)el2) || !(matcher = PARAM_PAIRS_PATTERN.matcher(el2)).matches()) continue;
                String valueKey = matcher.group(1);
                Object value = updateWrapper.getParamNameValuePairs().get(valueKey);
                Object ciphertext = this.doEncrypt(value, fieldEncrypt);
                updateWrapper.getParamNameValuePairs().put(valueKey, ciphertext);
            }
        }
    }

    private void encryptEntity(List<Field> fieldList, Object entity) {
        for (Field field : fieldList) {
            String ciphertext;
            IEncryptor encryptor = super.getEncryptor(field.getAnnotation(FieldEncrypt.class));
            Object fieldValue = ReflectUtil.getFieldValue((Object)entity, (Field)field);
            if (null == fieldValue) continue;
            String password = (String)ObjectUtil.defaultIfBlank((CharSequence)field.getAnnotation(FieldEncrypt.class).password(), (CharSequence)this.properties.getPassword());
            try {
                ciphertext = encryptor.encrypt(fieldValue.toString(), password, this.properties.getPublicKey());
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
            ReflectUtil.setFieldValue((Object)entity, (Field)field, (Object)ciphertext);
        }
    }

    private Object doEncrypt(Object parameterValue, FieldEncrypt fieldEncrypt) {
        if (null == parameterValue) {
            return null;
        }
        IEncryptor encryptor = super.getEncryptor(fieldEncrypt);
        String password = (String)ObjectUtil.defaultIfBlank((CharSequence)fieldEncrypt.password(), (CharSequence)this.properties.getPassword());
        try {
            return encryptor.encrypt(parameterValue.toString(), password, this.properties.getPublicKey());
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }
}

