/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.mask.core;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import top.continew.starter.security.mask.annotation.JsonMask;
import top.continew.starter.security.mask.strategy.IMaskStrategy;

public class JsonMaskSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private JsonMask jsonMask;

    public JsonMaskSerializer(JsonMask jsonMask) {
        this.jsonMask = jsonMask;
    }

    public JsonMaskSerializer() {
    }

    public void serialize(String str, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (CharSequenceUtil.isBlank((CharSequence)str)) {
            jsonGenerator.writeString("");
            return;
        }
        Class<? extends IMaskStrategy> strategyClass = this.jsonMask.strategy();
        IMaskStrategy maskStrategy = strategyClass != IMaskStrategy.class ? (IMaskStrategy)SpringUtil.getBean(strategyClass) : this.jsonMask.value();
        jsonGenerator.writeString(maskStrategy.mask(str, this.jsonMask.character(), this.jsonMask.left(), this.jsonMask.right()));
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (null == beanProperty) {
            return serializerProvider.findNullValueSerializer(null);
        }
        if (!Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        JsonMask jsonMaskAnnotation = (JsonMask)ObjectUtil.defaultIfNull((Object)((JsonMask)beanProperty.getAnnotation(JsonMask.class)), (Object)((JsonMask)beanProperty.getContextAnnotation(JsonMask.class)));
        if (null == jsonMaskAnnotation) {
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return new JsonMaskSerializer(jsonMaskAnnotation);
    }
}

