/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.web.util;

import cn.hutool.core.io.IoUtil;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class RepeatReadRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] cachedBody;
    private final HttpServletRequest originalRequest;

    public RepeatReadRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.originalRequest = request;
        if (!this.isMultipartContent(request)) {
            this.cachedBody = IoUtil.readBytes((InputStream)request.getInputStream(), (boolean)false);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.isMultipartContent(this.originalRequest)) {
            return this.originalRequest.getInputStream();
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.cachedBody);
        return new ServletInputStream(){

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        if (this.isMultipartContent(this.originalRequest)) {
            new BufferedReader(new InputStreamReader((InputStream)this.originalRequest.getInputStream(), StandardCharsets.UTF_8));
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public boolean isMultipartContent(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart/");
    }
}

