/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.web.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class RepeatReadResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream cachedOutputStream = new ByteArrayOutputStream();
    private final PrintWriter writer = new PrintWriter(this.cachedOutputStream, true);
    private boolean isStreamingResponse = false;

    public RepeatReadResponseWrapper(HttpServletResponse response) {
        super(response);
        this.checkStreamingResponse();
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (type != null) {
            String lowerType = type.toLowerCase();
            this.isStreamingResponse = lowerType.contains("text/event-stream");
        }
    }

    private void checkStreamingResponse() {
        String contentType = this.getContentType();
        if (contentType != null) {
            String lowerType = contentType.toLowerCase();
            this.isStreamingResponse = lowerType.contains("text/event-stream");
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.checkStreamingResponse();
        if (this.isStreamingResponse) {
            return super.getOutputStream();
        }
        return new ServletOutputStream(){

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                RepeatReadResponseWrapper.this.cachedOutputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                RepeatReadResponseWrapper.this.cachedOutputStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                RepeatReadResponseWrapper.this.cachedOutputStream.write(b, off, len);
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        this.checkStreamingResponse();
        if (this.isStreamingResponse) {
            return super.getWriter();
        }
        return this.writer;
    }

    public String getResponseContent() {
        if (!this.isStreamingResponse) {
            this.writer.flush();
            return this.cachedOutputStream.toString(StandardCharsets.UTF_8);
        }
        return null;
    }

    public void copyBodyToResponse() throws IOException {
        if (!this.isStreamingResponse && this.cachedOutputStream.size() > 0) {
            this.getResponse().getOutputStream().write(this.cachedOutputStream.toByteArray());
        }
    }

    public boolean isStreamingResponse() {
        return this.isStreamingResponse;
    }
}

