/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.web.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.spring.SpringUtil;
import jakarta.servlet.ServletContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.PathContainer;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class SpringWebUtils {
    private SpringWebUtils() {
    }

    public static boolean isMatch(String path, List<String> patterns) {
        return patterns.stream().anyMatch(pattern -> SpringWebUtils.isMatch(path, pattern));
    }

    public static boolean isMatch(String path, String ... patterns) {
        return Arrays.stream(patterns).anyMatch(pattern -> SpringWebUtils.isMatch(path, pattern));
    }

    public static boolean isMatch(String path, String pattern) {
        PathPattern pathPattern = PathPatternParser.defaultInstance.parse(pattern);
        PathContainer pathContainer = PathContainer.parsePath((String)path);
        return pathPattern.matches(pathContainer);
    }

    public static void deRegisterResourceHandler(Map<String, String> handlerMap) {
        ApplicationContext applicationContext = SpringUtil.getApplicationContext();
        HandlerMapping resourceHandlerMapping = (HandlerMapping)applicationContext.getBean("resourceHandlerMapping", HandlerMapping.class);
        Map oldHandlerMap = (Map)ReflectUtil.getFieldValue((Object)resourceHandlerMapping, (String)"handlerMap");
        for (Map.Entry<String, String> entry : handlerMap.entrySet()) {
            String pathPattern = CharSequenceUtil.appendIfMissing((CharSequence)entry.getKey(), (CharSequence)"/**", (CharSequence[])new CharSequence[0]);
            oldHandlerMap.remove(pathPattern);
        }
    }

    public static void registerResourceHandler(Map<String, String> handlerMap) {
        ApplicationContext applicationContext = SpringUtil.getApplicationContext();
        HandlerMapping resourceHandlerMapping = (HandlerMapping)applicationContext.getBean("resourceHandlerMapping", HandlerMapping.class);
        Map oldHandlerMap = (Map)ReflectUtil.getFieldValue((Object)resourceHandlerMapping, (String)"handlerMap");
        ServletContext servletContext = (ServletContext)applicationContext.getBean(ServletContext.class);
        ContentNegotiationManager contentNegotiationManager = (ContentNegotiationManager)applicationContext.getBean("mvcContentNegotiationManager", ContentNegotiationManager.class);
        UrlPathHelper urlPathHelper = (UrlPathHelper)applicationContext.getBean("mvcUrlPathHelper", UrlPathHelper.class);
        ResourceHandlerRegistry resourceHandlerRegistry = new ResourceHandlerRegistry(applicationContext, servletContext, contentNegotiationManager, urlPathHelper);
        for (Map.Entry<String, String> entry : handlerMap.entrySet()) {
            String pathPattern = CharSequenceUtil.appendIfMissing((CharSequence)CharSequenceUtil.removeSuffix((CharSequence)entry.getKey(), (CharSequence)"/"), (CharSequence)"/**", (CharSequence[])new CharSequence[0]);
            oldHandlerMap.remove(pathPattern);
            String resourceLocations = CharSequenceUtil.appendIfMissing((CharSequence)entry.getValue(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            resourceHandlerRegistry.addResourceHandler(new String[]{pathPattern}).addResourceLocations(new String[]{"file:" + resourceLocations});
        }
        Map additionalUrlMap = ((SimpleUrlHandlerMapping)ReflectUtil.invoke((Object)resourceHandlerRegistry, (String)"getHandlerMapping", (Object[])new Object[0])).getUrlMap();
        ReflectUtil.invoke((Object)resourceHandlerMapping, (String)"registerHandlers", (Object[])new Object[]{additionalUrlMap});
    }
}

