/*
 * Decompiled with CFR 0.152.
 */
package top.javatool.canal.client.client;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.protocol.Message;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.javatool.canal.client.client.CanalClient;
import top.javatool.canal.client.handler.MessageHandler;

public abstract class AbstractCanalClient
implements CanalClient {
    protected volatile boolean flag;
    private Logger log = LoggerFactory.getLogger(AbstractCanalClient.class);
    private Thread workThread;
    private CanalConnector connector;
    protected String filter = "";
    protected Integer batchSize = 1;
    protected Long timeout = 1L;
    protected TimeUnit unit = TimeUnit.SECONDS;
    private MessageHandler messageHandler;

    @Override
    public void start() {
        this.log.info("start canal client");
        this.workThread = new Thread(this::process);
        this.workThread.setName("canal-client-thread");
        this.flag = true;
        this.workThread.start();
    }

    @Override
    public void stop() {
        this.log.info("stop canal client");
        this.flag = false;
        if (null != this.workThread) {
            this.workThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        while (this.flag) {
            try {
                this.connector.connect();
                this.connector.subscribe(this.filter);
                while (this.flag) {
                    Message message = this.connector.getWithoutAck(this.batchSize.intValue(), this.timeout, this.unit);
                    this.log.info("\u83b7\u53d6\u6d88\u606f {}", (Object)message);
                    long batchId = message.getId();
                    if (message.getId() != -1L && message.getEntries().size() != 0) {
                        this.messageHandler.handleMessage(message);
                    }
                    this.connector.ack(batchId);
                }
            }
            catch (Exception e) {
                this.log.error("canal client \u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.connector.disconnect();
            }
        }
    }

    public void setConnector(CanalConnector connector) {
        this.connector = connector;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public CanalConnector getConnector() {
        return this.connector;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }
}

