/*
 * Decompiled with CFR 0.152.
 */
package top.javatool.canal.client.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public class StringConvertUtil {
    private static String[] PARSE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    static Object convertType(Class<?> type, String columnValue) {
        if (columnValue == null) {
            return null;
        }
        if (type.equals(Integer.class)) {
            return Integer.parseInt(columnValue);
        }
        if (type.equals(Long.class)) {
            return Long.parseLong(columnValue);
        }
        if (type.equals(Boolean.class)) {
            return StringConvertUtil.convertToBoolean(columnValue);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(columnValue);
        }
        if (type.equals(Double.class)) {
            return Double.parseDouble(columnValue);
        }
        if (type.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(columnValue));
        }
        if (type.equals(Date.class)) {
            return StringConvertUtil.parseDate(columnValue);
        }
        if (type.equals(java.sql.Date.class)) {
            return StringConvertUtil.parseDate(columnValue);
        }
        return columnValue;
    }

    private static Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String[])PARSE_PATTERNS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static boolean convertToBoolean(String value) {
        return "1".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }
}

