/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.jfunc.json.Json;
import top.jfunc.json.JsonArray;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseMapJSONObject;
import top.jfunc.json.impl.JSONArray;

public class JSONObject
extends BaseMapJSONObject {
    public JSONObject(Map<String, Object> map) {
        super(map);
    }

    public JSONObject() {
    }

    public JSONObject(String jsonString) {
        super(jsonString);
    }

    @Override
    protected Map<String, Object> str2Map(String jsonString) {
        return (Map)new Gson().fromJson(jsonString, Map.class);
    }

    @Override
    public JsonObject parse(String jsonString) {
        this.map = (Map)new Gson().fromJson(jsonString, Map.class);
        return this;
    }

    @Override
    public String serialize(Object javaBean) {
        return new Gson().toJson(javaBean);
    }

    @Override
    public <T> T deserialize(String jsonString, Class<T> clazz) {
        return (T)new Gson().fromJson(jsonString, clazz);
    }

    @Override
    public JsonObject getJsonObject(String key) {
        this.assertKey(key);
        Object temp = this.map.get(key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof Map) {
            return new JSONObject((Map)t);
        }
        return (JsonObject)t;
    }

    @Override
    public JsonArray getJsonArray(String key) {
        this.assertKey(key);
        Object temp = this.map.get(key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof List) {
            return new JSONArray((List)t);
        }
        return (JsonArray)t;
    }

    @Override
    public String toString() {
        HashMap<String, Json> map = new HashMap<String, Json>();
        for (String key : map.keySet()) {
            Object o = map.get(key);
            if (!(o instanceof JsonObject) && !(o instanceof JsonArray)) continue;
            map.put(key, (Json)o);
        }
        map.forEach((k, v) -> this.map.put(k, v.unwrap()));
        return new Gson().toJson((Object)this.map, Map.class);
    }

    @Override
    public JsonObject fromMap(Map<String, Object> map) {
        return new JSONObject(map);
    }
}

