/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import top.jfunc.json.JsonArray;
import top.jfunc.json.impl.BaseJson;
import top.jfunc.json.impl.ValueCompatible;

public abstract class BaseListJSONArray
extends BaseJson<BaseListJSONArray>
implements JsonArray {
    protected List<Object> list;

    public BaseListJSONArray(List<Object> list) {
        this.list = list;
    }

    public BaseListJSONArray() {
        this.list = new LinkedList<Object>();
    }

    public BaseListJSONArray(String arrayString) {
        this.list = this.str2List(arrayString);
    }

    public abstract List<Object> str2List(String var1);

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object get(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.list.get(index));
    }

    @Override
    public String getString(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        String temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, String.class) : (String)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public Boolean getBoolean(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        Boolean temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Boolean.class) : (Boolean)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public Integer getInteger(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        Integer temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Integer.class) : (Integer)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public Long getLong(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        Long temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Long.class) : (Long)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public Double getDouble(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        Double temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Double.class) : (Double)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public Float getFloat(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        Float temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Float.class) : (Float)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public BigInteger getBigInteger(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        BigInteger temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, BigInteger.class) : (BigInteger)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        this.assertIndex(index, this.size());
        Object value = this.list.get(index);
        BigDecimal temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, BigDecimal.class) : (BigDecimal)value;
        return this.checkNullValue(index, temp);
    }

    @Override
    public JsonArray remove(int index) {
        this.list.remove(index);
        return this;
    }

    @Override
    public JsonArray clear() {
        this.list.clear();
        return this;
    }

    @Override
    public JsonArray put(Object o) {
        this.list.add(o);
        return this;
    }

    @Override
    public JsonArray put(int index, Object o) {
        this.list.remove(index);
        this.list.add(index, o);
        return this;
    }

    @Override
    public JsonArray putAll(Collection<?> os) {
        this.list.addAll(os);
        return this;
    }

    @Override
    public JsonArray fromList(List<Object> list) {
        this.list = list;
        return this;
    }

    @Override
    public List<Object> unwrap() {
        return this.list;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }
}

