/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;
import top.jfunc.json.Json;
import top.jfunc.json.JsonArray;
import top.jfunc.json.JsonException;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseMapJSONObject;
import top.jfunc.json.impl.JSONArray;
import top.jfunc.json.strategy.FieldExclusionStrategy;
import top.jfunc.json.strategy.FieldNameChangeNamingStrategy;

public class JSONObject
extends BaseMapJSONObject {
    public JSONObject(Map<String, Object> map) {
        super(map);
    }

    public JSONObject() {
    }

    public JSONObject(String jsonString) {
        super(jsonString);
    }

    protected Map<String, Object> str2Map(String jsonString) {
        return (Map)new Gson().fromJson(jsonString, Map.class);
    }

    protected String map2Str(Map<String, Object> map) {
        return new Gson().toJson(map, Map.class);
    }

    public JsonObject parse(String jsonString) {
        this.map = (Map)new Gson().fromJson(jsonString, Map.class);
        return this;
    }

    public <T> String serialize(T javaBean, boolean nullHold, String ... ignoreFields) {
        GsonBuilder gsonBuilder = new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)new FieldNameChangeNamingStrategy()).addSerializationExclusionStrategy((ExclusionStrategy)new FieldExclusionStrategy(ignoreFields));
        if (nullHold) {
            return gsonBuilder.serializeNulls().create().toJson(javaBean);
        }
        return gsonBuilder.create().toJson(javaBean);
    }

    public <T> T deserialize(String jsonString, Class<T> clazz) {
        return (T)new Gson().fromJson(jsonString, clazz);
    }

    public JsonObject getJsonObject(String key) {
        this.assertKey(key);
        Object temp = this.map.get(key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof Map) {
            return new JSONObject((Map)t);
        }
        return (JsonObject)t;
    }

    public JsonArray getJsonArray(String key) {
        this.assertKey(key);
        Object temp = this.map.get(key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof List) {
            return new JSONArray((List)t);
        }
        return (JsonArray)t;
    }

    public JsonObject fromMap(Map<String, Object> map) {
        return new JSONObject(map);
    }

    public Json toJson(Object o) {
        if (o instanceof List) {
            return new JSONArray((List)o);
        }
        if (o instanceof Map) {
            return new JSONObject((Map)o);
        }
        try {
            return (Json)o;
        }
        catch (Exception e) {
            throw new JsonException("\u4e0d\u80fd\u5c06\u975eJson\u7684\u5bf9\u8c61\u8f6c\u6362\u4e3aJson");
        }
    }
}

