/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageResult<T>
implements Serializable {
    private static final long serialVersionUID = 2696109518770817050L;
    private int pgCt;
    private int pgSz;
    private int end;
    private int total;
    private List<T> datas = new ArrayList<T>();

    public PageResult(int pgCt, int pgSz) {
        this(pgCt, pgSz, 0);
    }

    public PageResult(int pgCt, int pgSz, int total) {
        this.pgCt = pgCt < 1 ? 1 : pgCt;
        this.pgSz = pgSz < 1 ? 10 : pgSz;
        this.total = total;
        this.end = (total + pgSz - 1) / pgSz;
    }

    public PageResult(int pgCt, int pgSz, int total, List<T> datas) {
        this(pgCt, pgSz, total);
        this.datas = datas;
    }

    public int getPgCt() {
        return this.pgCt;
    }

    public int getPgSz() {
        return this.pgSz;
    }

    public int getEnd() {
        return this.end;
    }

    public int getTotal() {
        return this.total;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setPgCt(int pgCt) {
        this.pgCt = pgCt;
    }

    public void setPgSz(int pgSz) {
        this.pgSz = pgSz;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPgCt() != other.getPgCt()) {
            return false;
        }
        if (this.getPgSz() != other.getPgSz()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$datas = this.getDatas();
        List<T> other$datas = other.getDatas();
        return !(this$datas == null ? other$datas != null : !((Object)this$datas).equals(other$datas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPgCt();
        result = result * 59 + this.getPgSz();
        result = result * 59 + this.getEnd();
        result = result * 59 + this.getTotal();
        List<T> $datas = this.getDatas();
        result = result * 59 + ($datas == null ? 43 : ((Object)$datas).hashCode());
        return result;
    }

    public String toString() {
        return "PageResult(pgCt=" + this.getPgCt() + ", pgSz=" + this.getPgSz() + ", end=" + this.getEnd() + ", total=" + this.getTotal() + ", datas=" + this.getDatas() + ")";
    }
}

