/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.config;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import top.lshaci.framework.mybatis.datasource.DynamicDataSource;
import top.lshaci.framework.mybatis.datasource.DynamicDataSourceAspect;
import top.lshaci.framework.mybatis.datasource.DynamicDataSourceType;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:datasource_first.properties"}), @PropertySource(value={"classpath:datasource_second.properties"})})
@ConditionalOnProperty(value={"datasource.dynamic"}, havingValue="true")
public class DynamicDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceConfig.class);

    @Bean(name={"firstDataSource"})
    @ConfigurationProperties(value="spring.datasource.druid.first")
    @ConditionalOnProperty(value={"spring.datasource.druid.first.url"})
    public DataSource firstDataSource() {
        log.debug("Init First Druid DataSource...");
        return new DruidDataSource();
    }

    @Bean(name={"secondDataSource"})
    @ConfigurationProperties(value="spring.datasource.druid.second")
    @ConditionalOnProperty(value={"spring.datasource.druid.second.url"})
    public DataSource secondDataSource() {
        log.debug("Init Second Druid DataSource...");
        return new DruidDataSource();
    }

    @Primary
    @Bean(name={"dataSource"})
    @DependsOn(value={"firstDataSource", "secondDataSource"})
    public DynamicDataSource dynamicDataSource() {
        log.debug("Init Dynamic Druid DataSource...");
        DynamicDataSource dataSource = new DynamicDataSource();
        HashMap<DynamicDataSourceType, DataSource> targetDataSources = new HashMap<DynamicDataSourceType, DataSource>();
        targetDataSources.put(DynamicDataSourceType.FIRST, this.firstDataSource());
        targetDataSources.put(DynamicDataSourceType.SECOND, this.secondDataSource());
        dataSource.setTargetDataSources(targetDataSources);
        dataSource.setDefaultTargetDataSource(this.firstDataSource());
        return dataSource;
    }

    @Bean
    public DataSourceTransactionManager transactionManager() {
        log.debug("Init Data Source Transaction Manager...");
        return new DataSourceTransactionManager((DataSource)((Object)this.dynamicDataSource()));
    }

    @Bean
    public DynamicDataSourceAspect dynamicDataSourceAspect() {
        log.debug("Config Dynamic Data Source Aspect...");
        return new DynamicDataSourceAspect();
    }
}

