/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.FileTypeUtil;
import top.lshaci.framework.utils.StreamUtils;
import top.lshaci.framework.utils.enums.FileType;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class FileUploadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    public static void verifySuffix(String filename, List<String> allowSuffixes) throws UtilException {
        if (StringUtils.isBlank((CharSequence)filename)) {
            throw new UtilException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(allowSuffixes)) {
            throw new UtilException("\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String suffix = filename.substring(filename.lastIndexOf(".") + 1);
        if (StringUtils.isBlank((CharSequence)suffix)) {
            throw new UtilException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
        }
        if (!allowSuffixes.contains(suffix.trim().toUpperCase()) && !allowSuffixes.contains(suffix.trim().toLowerCase())) {
            throw new UtilException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u88ab\u5141\u8bb8");
        }
    }

    public static void verifySuffix(InputStream inputStream, List<FileType> allowFileTypes) throws UtilException {
        if (inputStream == null) {
            throw new UtilException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(allowFileTypes)) {
            throw new UtilException("\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileType fileType = null;
        try {
            fileType = FileTypeUtil.getType(inputStream);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u9519\u8bef", (Throwable)e);
            throw new UtilException("\u4e0a\u4f20\u6587\u4ef6\u53d1\u9001\u9519\u8bef");
        }
        if (fileType == null || !allowFileTypes.contains((Object)fileType)) {
            throw new UtilException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u88ab\u5141\u8bb8");
        }
    }

    public static String saveFile(String filePath, String prefix, String suffix, InputStream inputStream) throws UtilException {
        if (inputStream == null) {
            throw new UtilException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)filePath)) {
            throw new UtilException("The file path or save file name is empty!");
        }
        String saveFileName = prefix + "-" + UUID.randomUUID().toString() + "." + suffix;
        File saveFile = new File(filePath, saveFileName);
        if (!saveFile.getParentFile().exists()) {
            saveFile.getParentFile().mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(saveFile);){
            StreamUtils.write(inputStream, os);
        }
        catch (IOException | IllegalStateException e) {
            log.error("Failed to save file!", (Throwable)e);
            throw new UtilException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25", e);
        }
        return saveFileName;
    }
}

