/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.utils.exception.UtilException;

public abstract class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static <E> E newInstance(Class<E> clazz) {
        Objects.requireNonNull(clazz, "The class is must not be null!");
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Use reflection new instance is error!", (Throwable)e);
            throw new UtilException("Create instance is error of class is : " + clazz.getName());
        }
    }

    public static Object invokeMethod(Object obj, Method method, Object ... args) {
        Objects.requireNonNull(obj, "The object is must not be null!");
        Objects.requireNonNull(method, "The method is must not be null!");
        try {
            method.setAccessible(true);
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("Invoke method is error!", (Throwable)e);
            throw new UtilException("Invoke method is error of method is : " + method.getName());
        }
    }

    public static Object getFieldValue(Object obj, Field field) {
        ReflectionUtils.checkFieldOperationParams(obj, field);
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error("Get field value is error!", (Throwable)e);
            throw new UtilException("Get field value is error of field is : " + field.getName());
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        ReflectionUtils.checkFieldOperationParams(obj, field);
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error("Set field value is error!", (Throwable)e);
            throw new UtilException("Set field value is error of field is : " + field.getName());
        }
    }

    private static void checkFieldOperationParams(Object obj, Field field) {
        Objects.requireNonNull(obj, "The object is must not be null!");
        Objects.requireNonNull(field, "The field is must not be null!");
    }
}

