/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.aspect;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import top.lshaci.framework.web.exception.RepeatSubmitException;
import top.lshaci.framework.web.utils.HttpRequestUtils;
import top.lshaci.framework.web.utils.HttpSessionUtils;

@Aspect
@Order(value=2)
public class PreventRepeatSubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(PreventRepeatSubmitAspect.class);
    private static final String SUBMIT_TOKEN_PREFIX = "SUBMIT_TOKEN";
    private static final String SUBMIT_TOKEN_SEPARATOR = "_";

    @Pointcut(value="@annotation(top.lshaci.framework.web.annotation.PreventRepeatSubmit)")
    public void preventRepeatSubmit() {
    }

    @Before(value="preventRepeatSubmit()")
    public void doBefore() {
        HttpServletRequest request = HttpRequestUtils.get();
        String requestUrl = request.getRequestURI();
        log.info("PreventRepeatSubmitAspect: the request url is: {}.", (Object)requestUrl);
        Object tokenKey = HttpSessionUtils.getAttribute(requestUrl);
        if (tokenKey != null) {
            log.warn("In operation...");
            throw new RepeatSubmitException();
        }
        String token = SUBMIT_TOKEN_PREFIX + SUBMIT_TOKEN_SEPARATOR + UUID.randomUUID().toString() + SUBMIT_TOKEN_SEPARATOR + System.currentTimeMillis();
        HttpSessionUtils.setAttribute(requestUrl, token);
    }

    @AfterReturning(value="preventRepeatSubmit()")
    public void doAfterReturning() {
        String requestUrl = HttpRequestUtils.get().getRequestURI();
        HttpSessionUtils.removeAttribute(requestUrl);
        log.info("Remove submit token key from session is succeed.");
    }

    @AfterThrowing(value="preventRepeatSubmit()", throwing="e")
    public void doAfterThrowing(Exception e) {
        if (e instanceof RepeatSubmitException) {
            log.warn("In operation...");
            return;
        }
        String requestUrl = HttpRequestUtils.get().getRequestURI();
        HttpSessionUtils.removeAttribute(requestUrl);
        log.info("Remove submit token key from session is succeed.");
    }
}

