/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.context.request.RequestContextListener;
import top.lshaci.framework.web.aspect.PreventRepeatSubmitAspect;
import top.lshaci.framework.web.aspect.UserRoleAspect;
import top.lshaci.framework.web.aspect.WebLogAspect;
import top.lshaci.framework.web.handler.exception.GlobalExceptionHandler;
import top.lshaci.framework.web.utils.DownloadUtils;

@Configuration
@PropertySource(value={"classpath:web.properties"})
public class WebMvcConfig {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);

    @Bean
    public RequestContextListener requestContextListener() {
        log.debug("Config request context listener...");
        return new RequestContextListener();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"web.enabled.globalExceptionHandler"}, havingValue="true")
    public GlobalExceptionHandler globalExceptionHandler() {
        log.debug("Config global exception handler...");
        return new GlobalExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"web.enabled.webLogAspect"}, havingValue="true")
    public WebLogAspect webLogAspect() {
        log.debug("Config web log aspect...");
        return new WebLogAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"web.enabled.preventRepeatSubmitAspect"}, havingValue="true")
    public PreventRepeatSubmitAspect preventRepeatSubmitAspect() {
        log.debug("Config prevent repeat submit aspect...");
        return new PreventRepeatSubmitAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"web.enabled.userRole"}, havingValue="true")
    public UserRoleAspect userRoleAspect() {
        log.debug("Config user role aspect...");
        return new UserRoleAspect();
    }

    @Autowired
    public void setDownloadCacheSize(@Value(value="${web.download.cacheSize}") int downloadCacheSize) {
        if (downloadCacheSize <= 0) {
            downloadCacheSize = 2048;
        }
        log.debug("Set DownloadUtils cacheSize: {} bytes", (Object)downloadCacheSize);
        DownloadUtils.cacheSize = downloadCacheSize;
    }
}

