/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.handler.exception;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import top.lshaci.framework.common.exception.BaseException;
import top.lshaci.framework.web.enums.ErrorCode;
import top.lshaci.framework.web.model.JsonResponse;

@RestController
@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String SYSTEM_EXCEPTION = "System be happend exception!";
    private static final String FIELD = "\u5b57\u6bb5:";

    @ExceptionHandler(value={BaseException.class})
    public JsonResponse<Object> baseExceptionHandler(HttpServletRequest req, Exception e) {
        log.error(SYSTEM_EXCEPTION, (Throwable)e);
        return JsonResponse.failure(e.getMessage()).setCode(ErrorCode.INTERNAL_PROGRAM_ERROR.getCode());
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public JsonResponse<Object> argumentExceptionHandler(HttpServletRequest req, Exception e) {
        log.error(SYSTEM_EXCEPTION, (Throwable)e);
        StringBuilder message = new StringBuilder();
        FieldError fieldError = null;
        if (e instanceof BindException) {
            BindException bindException = (BindException)e;
            fieldError = (FieldError)bindException.getBindingResult().getFieldErrors().get(0);
        } else if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException argumentNotValidException = (MethodArgumentNotValidException)e;
            fieldError = (FieldError)argumentNotValidException.getBindingResult().getFieldErrors().get(0);
        }
        if (fieldError != null) {
            String field = fieldError.getField();
            log.warn(FIELD + field);
            String msg = fieldError.getDefaultMessage();
            message.append(msg);
        }
        return JsonResponse.failure(message.toString());
    }

    @ExceptionHandler(value={Exception.class})
    public JsonResponse<Object> defaultExceptionHandler(HttpServletRequest req, Exception e) {
        log.error(SYSTEM_EXCEPTION, (Throwable)e);
        ErrorCode errorCode = ErrorCode.getByException(e);
        return JsonResponse.failure(errorCode.getMsg()).setCode(errorCode.getCode()).addOtherData("detail", e.getMessage());
    }
}

