/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.lshaci.framework.web.enums.ContentType;
import top.lshaci.framework.web.enums.Encoding;
import top.lshaci.framework.web.model.JsonResponse;

public class HttpResponseUtils {
    public static HttpServletResponse getResponse() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = requestAttributes.getResponse();
        Objects.requireNonNull(response, "The http response is null!");
        return response;
    }

    public static <R> void responseJson(JsonResponse<R> jsonResponse) throws IOException {
        HttpServletResponse response = HttpResponseUtils.getResponse();
        response.setCharacterEncoding(Encoding.UTF_8.getName());
        response.setContentType(ContentType.JSON_UTF_8.getName());
        response.getWriter().write(JSON.toJSONString(jsonResponse));
    }
}

