/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.dt.rmfc.server.service.impl;

import com.lshaci.validate.utils.ValidateUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import top.lshaci.dt.rmfc.common.enums.MessageStatus;
import top.lshaci.dt.rmfc.common.exception.DtMessageException;
import top.lshaci.dt.rmfc.common.model.DtMessage;
import top.lshaci.dt.rmfc.server.mapper.DtMessageMapper;
import top.lshaci.dt.rmfc.server.mq.producer.ActiveMQProducer;
import top.lshaci.dt.rmfc.server.service.DtMessageService;

@Service
@Transactional(isolation=Isolation.REPEATABLE_READ, propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, transactionManager="transactionManager")
public class DtMessageServiceImpl
implements DtMessageService {
    private static final Logger logger = LoggerFactory.getLogger(DtMessageServiceImpl.class);
    private static final String SEND_SUCCESSED = "Send message({}) successed.";
    @Autowired
    private DtMessageMapper mapper;
    @Autowired
    private ActiveMQProducer producer;

    @PostConstruct
    private void createTable() {
        this.mapper.createTable();
        logger.debug("Create table successed.");
    }

    public void preSend(DtMessage message) throws DtMessageException {
        this.validateMessage(message);
        if (this.mapper.save(message) != 1) {
            logger.error("Save this message(" + message.getId() + ") failed!");
            throw new DtMessageException("Save this message(" + message.getId() + ")  failed!");
        }
        logger.debug("Save this message({}) successed.", (Object)message.getId());
    }

    public void confirmSend(String messageId) throws DtMessageException {
        DtMessage message = this.findMessageById(messageId);
        message.setStatus(MessageStatus.SENDING);
        message.setSendTime(new Date());
        this.updateMessage(message);
        this.producer.sendMessage(message.getQueueName(), (Object)message);
        logger.debug(SEND_SUCCESSED, (Object)messageId);
    }

    public void resend(String messageId) throws DtMessageException {
        DtMessage message = this.findMessageById(messageId);
        message.addRetry();
        message.setSendTime(new Date());
        this.updateMessage(message);
        this.producer.sendMessage(message.getQueueName(), (Object)message);
        logger.debug(SEND_SUCCESSED, (Object)messageId);
    }

    public void directSend(DtMessage message) throws DtMessageException {
        this.validateMessage(message);
        this.producer.sendMessage(message.getQueueName(), (Object)message);
        logger.debug(SEND_SUCCESSED, (Object)message.getId());
    }

    public void received(String messageId) throws DtMessageException {
        DtMessage message = this.findMessageById(messageId);
        message.setReceivedTime(new Date());
        message.setStatus(MessageStatus.SENT);
        this.updateMessage(message);
    }

    public void delete(String messageId) throws DtMessageException {
        this.findMessageById(messageId);
        if (this.mapper.delete(messageId) != 1) {
            logger.error("Delete this message(" + messageId + ") failed!");
            throw new DtMessageException("Delete this message(" + messageId + ") failed!");
        }
        logger.debug("Delete this message({}) successed!", (Object)messageId);
    }

    public void updateMessage(DtMessage message) throws DtMessageException {
        if (this.mapper.update(message) != 1) {
            logger.error("Update this message(" + message.getId() + ") failed!");
            throw new DtMessageException("Update this message(" + message.getId() + ")  failed!");
        }
    }

    public List<DtMessage> findByStatus(MessageStatus status) throws DtMessageException {
        if (status == null) {
            logger.error("Message status is null!");
            throw new DtMessageException("Message status is null!");
        }
        return this.mapper.findByStatus(status);
    }

    private DtMessage findMessageById(String messageId) throws DtMessageException {
        if (StringUtils.isEmpty((Object)messageId)) {
            logger.error("This messageId(" + messageId + ") is empty!");
            throw new DtMessageException("This messageId(" + messageId + ") is empty!");
        }
        DtMessage message = this.mapper.find(messageId);
        if (message == null) {
            logger.error("This message(" + messageId + ") is null!");
            throw new DtMessageException("This message(" + messageId + ") is null!");
        }
        return message;
    }

    private void validateMessage(DtMessage message) throws DtMessageException {
        if (!ValidateUtils.validate((Object)message)) {
            logger.error(ValidateUtils.detailValidate((Object)message).toString());
            throw new DtMessageException("This message not validated!");
        }
    }
}

