// Copyright 2025, miuix-kotlin-multiplatform contributors
// SPDX-License-Identifier: Apache-2.0

package top.yukonga.miuix.kmp.icon.icons.useful

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import top.yukonga.miuix.kmp.icon.MiuixIcons

val MiuixIcons.Useful.Blocklist: ImageVector
    get() {
        if (_blocklist != null) return _blocklist!!
        _blocklist = ImageVector.Builder("Blocklist", 26.0.dp, 26.0.dp, 26.0f, 26.0f).apply {
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(12.651f, 22.135f)
                curveTo(12.945f, 22.135f, 13.092f, 22.135f, 13.165f, 22.083f)
                curveTo(13.233f, 22.034f, 13.27f, 21.973f, 13.28f, 21.889f)
                curveTo(13.291f, 21.8f, 13.215f, 21.661f, 13.064f, 21.382f)
                curveTo(13.016f, 21.295f, 12.971f, 21.206f, 12.928f, 21.116f)
                curveTo(12.816f, 20.883f, 12.759f, 20.767f, 12.692f, 20.699f)
                curveTo(12.627f, 20.634f, 12.568f, 20.597f, 12.481f, 20.567f)
                curveTo(12.391f, 20.535f, 12.279f, 20.535f, 12.054f, 20.535f)
                horizontalLineTo(5.323f)
                curveTo(5.126f, 20.535f, 5.028f, 20.535f, 4.952f, 20.497f)
                curveTo(4.886f, 20.463f, 4.833f, 20.409f, 4.799f, 20.343f)
                curveTo(4.761f, 20.268f, 4.761f, 20.17f, 4.761f, 19.973f)
                verticalLineTo(18.94f)
                curveTo(4.761f, 18.437f, 4.761f, 18.185f, 4.85f, 17.948f)
                curveTo(4.923f, 17.752f, 5.068f, 17.538f, 5.222f, 17.398f)
                curveTo(5.41f, 17.228f, 5.617f, 17.145f, 6.032f, 16.98f)
                curveTo(8.035f, 16.183f, 10.311f, 15.711f, 12.729f, 15.661f)
                curveTo(12.829f, 15.659f, 12.879f, 15.658f, 12.92f, 15.643f)
                curveTo(12.959f, 15.63f, 12.989f, 15.613f, 13.019f, 15.585f)
                curveTo(13.051f, 15.555f, 13.077f, 15.51f, 13.129f, 15.419f)
                curveTo(13.241f, 15.223f, 13.363f, 15.034f, 13.495f, 14.853f)
                curveTo(13.703f, 14.567f, 13.807f, 14.425f, 13.804f, 14.329f)
                curveTo(13.802f, 14.241f, 13.766f, 14.171f, 13.697f, 14.117f)
                curveTo(13.622f, 14.058f, 13.462f, 14.057f, 13.143f, 14.054f)
                curveTo(13.096f, 14.054f, 13.048f, 14.054f, 13.0f, 14.054f)
                curveTo(10.418f, 14.054f, 7.946f, 14.526f, 5.666f, 15.389f)
                curveTo(4.91f, 15.675f, 4.532f, 15.818f, 4.136f, 16.168f)
                curveTo(3.825f, 16.444f, 3.497f, 16.918f, 3.35f, 17.306f)
                curveTo(3.162f, 17.801f, 3.162f, 18.297f, 3.162f, 19.288f)
                verticalLineTo(19.324f)
                curveTo(3.162f, 20.308f, 3.162f, 20.8f, 3.354f, 21.176f)
                curveTo(3.522f, 21.507f, 3.791f, 21.775f, 4.121f, 21.944f)
                curveTo(4.497f, 22.135f, 4.989f, 22.135f, 5.973f, 22.135f)
                horizontalLineTo(12.651f)
                close()
            }
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(13.186f, 10.895f)
                curveTo(14.976f, 10.895f, 16.428f, 9.443f, 16.428f, 7.653f)
                curveTo(16.428f, 5.862f, 14.976f, 4.411f, 13.186f, 4.411f)
                curveTo(11.395f, 4.411f, 9.944f, 5.862f, 9.944f, 7.653f)
                curveTo(9.944f, 9.443f, 11.395f, 10.895f, 13.186f, 10.895f)
                close()
                moveTo(13.186f, 12.495f)
                curveTo(15.86f, 12.495f, 18.028f, 10.327f, 18.028f, 7.653f)
                curveTo(18.028f, 4.979f, 15.86f, 2.811f, 13.186f, 2.811f)
                curveTo(10.512f, 2.811f, 8.344f, 4.979f, 8.344f, 7.653f)
                curveTo(8.344f, 10.327f, 10.512f, 12.495f, 13.186f, 12.495f)
                close()
            }
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(23.189f, 18.459f)
                curveTo(23.189f, 21.072f, 21.071f, 23.189f, 18.459f, 23.189f)
                curveTo(15.847f, 23.189f, 13.729f, 21.072f, 13.729f, 18.459f)
                curveTo(13.729f, 15.847f, 15.847f, 13.729f, 18.459f, 13.729f)
                curveTo(21.071f, 13.729f, 23.189f, 15.847f, 23.189f, 18.459f)
                close()
                moveTo(20.034f, 21.165f)
                curveTo(19.571f, 21.435f, 19.033f, 21.589f, 18.459f, 21.589f)
                curveTo(16.73f, 21.589f, 15.329f, 20.188f, 15.329f, 18.459f)
                curveTo(15.329f, 17.885f, 15.484f, 17.347f, 15.753f, 16.885f)
                lineTo(20.034f, 21.165f)
                close()
                moveTo(21.165f, 20.034f)
                lineTo(16.885f, 15.753f)
                curveTo(17.347f, 15.484f, 17.885f, 15.329f, 18.459f, 15.329f)
                curveTo(20.188f, 15.329f, 21.589f, 16.73f, 21.589f, 18.459f)
                curveTo(21.589f, 19.033f, 21.435f, 19.571f, 21.165f, 20.034f)
                close()
            }
        }.build()
        return _blocklist!!
    }

private var _blocklist: ImageVector? = null