// Copyright 2025, miuix-kotlin-multiplatform contributors
// SPDX-License-Identifier: Apache-2.0

package top.yukonga.miuix.kmp.icon.icons.useful

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import top.yukonga.miuix.kmp.icon.MiuixIcons

val MiuixIcons.Useful.Edit: ImageVector
    get() {
        if (_edit != null) return _edit!!
        _edit = ImageVector.Builder("Edit", 26.0.dp, 26.0.dp, 26.0f, 26.0f).apply {
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(3.865f, 21.53f)
                curveTo(3.865f, 21.308f, 3.865f, 21.198f, 3.896f, 21.108f)
                curveTo(3.952f, 20.945f, 4.08f, 20.817f, 4.244f, 20.76f)
                curveTo(4.333f, 20.73f, 4.444f, 20.73f, 4.665f, 20.73f)
                horizontalLineTo(21.335f)
                curveTo(21.556f, 20.73f, 21.667f, 20.73f, 21.756f, 20.76f)
                curveTo(21.92f, 20.817f, 22.048f, 20.945f, 22.104f, 21.108f)
                curveTo(22.135f, 21.198f, 22.135f, 21.308f, 22.135f, 21.53f)
                curveTo(22.135f, 21.751f, 22.135f, 21.862f, 22.104f, 21.951f)
                curveTo(22.048f, 22.114f, 21.92f, 22.243f, 21.756f, 22.299f)
                curveTo(21.667f, 22.33f, 21.556f, 22.33f, 21.335f, 22.33f)
                horizontalLineTo(4.665f)
                curveTo(4.444f, 22.33f, 4.333f, 22.33f, 4.244f, 22.299f)
                curveTo(4.08f, 22.243f, 3.952f, 22.114f, 3.896f, 21.951f)
                curveTo(3.865f, 21.862f, 3.865f, 21.751f, 3.865f, 21.53f)
                close()
            }
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(15.254f, 3.946f)
                curveTo(15.888f, 3.313f, 16.205f, 2.996f, 16.57f, 2.877f)
                curveTo(16.891f, 2.773f, 17.237f, 2.773f, 17.559f, 2.877f)
                curveTo(17.924f, 2.996f, 18.241f, 3.313f, 18.875f, 3.946f)
                lineTo(19.253f, 4.324f)
                curveTo(19.886f, 4.958f, 20.203f, 5.275f, 20.322f, 5.64f)
                curveTo(20.426f, 5.961f, 20.426f, 6.307f, 20.322f, 6.629f)
                curveTo(20.203f, 6.994f, 19.886f, 7.311f, 19.253f, 7.945f)
                lineTo(8.128f, 19.069f)
                curveTo(8.031f, 19.166f, 7.983f, 19.215f, 7.926f, 19.249f)
                curveTo(7.876f, 19.28f, 7.821f, 19.303f, 7.764f, 19.317f)
                curveTo(7.699f, 19.332f, 7.63f, 19.332f, 7.492f, 19.332f)
                lineTo(4.766f, 19.332f)
                curveTo(4.451f, 19.332f, 4.294f, 19.332f, 4.174f, 19.271f)
                curveTo(4.068f, 19.217f, 3.982f, 19.131f, 3.928f, 19.025f)
                curveTo(3.867f, 18.905f, 3.867f, 18.747f, 3.867f, 18.433f)
                lineTo(3.867f, 15.706f)
                curveTo(3.867f, 15.569f, 3.867f, 15.5f, 3.882f, 15.435f)
                curveTo(3.896f, 15.378f, 3.919f, 15.323f, 3.95f, 15.273f)
                curveTo(3.984f, 15.216f, 4.033f, 15.167f, 4.13f, 15.07f)
                lineTo(15.254f, 3.946f)
                close()
                moveTo(16.607f, 4.853f)
                curveTo(16.765f, 4.695f, 16.844f, 4.615f, 16.935f, 4.586f)
                curveTo(17.016f, 4.56f, 17.102f, 4.56f, 17.183f, 4.586f)
                curveTo(17.274f, 4.615f, 17.353f, 4.695f, 17.512f, 4.853f)
                lineTo(18.346f, 5.687f)
                curveTo(18.504f, 5.846f, 18.583f, 5.925f, 18.613f, 6.016f)
                curveTo(18.639f, 6.096f, 18.639f, 6.183f, 18.613f, 6.263f)
                curveTo(18.583f, 6.355f, 18.504f, 6.434f, 18.346f, 6.592f)
                lineTo(16.717f, 8.221f)
                lineTo(14.978f, 6.482f)
                lineTo(16.607f, 4.853f)
                close()
                moveTo(13.846f, 7.613f)
                lineTo(5.638f, 15.821f)
                curveTo(5.59f, 15.87f, 5.565f, 15.894f, 5.548f, 15.923f)
                curveTo(5.532f, 15.948f, 5.521f, 15.975f, 5.514f, 16.004f)
                curveTo(5.506f, 16.036f, 5.506f, 16.071f, 5.506f, 16.139f)
                lineTo(5.506f, 17.243f)
                curveTo(5.506f, 17.4f, 5.506f, 17.479f, 5.537f, 17.539f)
                curveTo(5.564f, 17.592f, 5.607f, 17.635f, 5.66f, 17.662f)
                curveTo(5.72f, 17.692f, 5.799f, 17.692f, 5.956f, 17.692f)
                lineTo(7.059f, 17.692f)
                curveTo(7.128f, 17.692f, 7.162f, 17.692f, 7.195f, 17.684f)
                curveTo(7.223f, 17.678f, 7.251f, 17.666f, 7.276f, 17.651f)
                curveTo(7.304f, 17.633f, 7.329f, 17.609f, 7.377f, 17.561f)
                lineTo(15.585f, 9.352f)
                lineTo(13.846f, 7.613f)
                close()
            }
        }.build()
        return _edit!!
    }

private var _edit: ImageVector? = null