// Copyright 2025, miuix-kotlin-multiplatform contributors
// SPDX-License-Identifier: Apache-2.0

package top.yukonga.miuix.kmp.icon.icons.useful

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import top.yukonga.miuix.kmp.icon.MiuixIcons

val MiuixIcons.Useful.NavigatorSwitch: ImageVector
    get() {
        if (_navigatorSwitch != null) return _navigatorSwitch!!
        _navigatorSwitch = ImageVector.Builder("NavigatorSwitch", 26.0.dp, 26.0.dp, 26.0f, 26.0f).apply {
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(19.541f, 4.216f)
                curveTo(20.941f, 4.216f, 21.641f, 4.216f, 22.176f, 4.489f)
                curveTo(22.646f, 4.728f, 23.028f, 5.111f, 23.268f, 5.581f)
                curveTo(23.541f, 6.116f, 23.541f, 6.816f, 23.541f, 8.216f)
                verticalLineTo(17.784f)
                curveTo(23.541f, 19.184f, 23.541f, 19.884f, 23.268f, 20.419f)
                curveTo(23.028f, 20.889f, 22.646f, 21.272f, 22.176f, 21.511f)
                curveTo(21.641f, 21.784f, 20.941f, 21.784f, 19.541f, 21.784f)
                horizontalLineTo(6.459f)
                curveTo(5.059f, 21.784f, 4.359f, 21.784f, 3.825f, 21.511f)
                curveTo(3.354f, 21.272f, 2.972f, 20.889f, 2.732f, 20.419f)
                curveTo(2.46f, 19.884f, 2.46f, 19.184f, 2.46f, 17.784f)
                verticalLineTo(8.216f)
                curveTo(2.46f, 6.816f, 2.46f, 6.116f, 2.732f, 5.581f)
                curveTo(2.972f, 5.111f, 3.354f, 4.728f, 3.825f, 4.489f)
                curveTo(4.359f, 4.216f, 5.059f, 4.216f, 6.459f, 4.216f)
                horizontalLineTo(19.541f)
                close()
                moveTo(20.34f, 5.815f)
                curveTo(20.9f, 5.815f, 21.18f, 5.815f, 21.394f, 5.924f)
                curveTo(21.582f, 6.02f, 21.735f, 6.173f, 21.831f, 6.361f)
                curveTo(21.94f, 6.575f, 21.94f, 6.855f, 21.94f, 7.415f)
                verticalLineTo(18.585f)
                curveTo(21.94f, 19.145f, 21.94f, 19.425f, 21.831f, 19.639f)
                curveTo(21.735f, 19.827f, 21.582f, 19.98f, 21.394f, 20.076f)
                curveTo(21.18f, 20.185f, 20.9f, 20.185f, 20.34f, 20.185f)
                horizontalLineTo(12.746f)
                verticalLineTo(5.815f)
                lineTo(20.34f, 5.815f)
                close()
                moveTo(11.146f, 5.815f)
                lineTo(5.66f, 5.815f)
                curveTo(5.1f, 5.815f, 4.82f, 5.815f, 4.606f, 5.924f)
                curveTo(4.418f, 6.02f, 4.265f, 6.173f, 4.169f, 6.361f)
                curveTo(4.06f, 6.575f, 4.06f, 6.855f, 4.06f, 7.415f)
                lineTo(4.06f, 18.585f)
                curveTo(4.06f, 19.145f, 4.06f, 19.425f, 4.169f, 19.639f)
                curveTo(4.265f, 19.827f, 4.418f, 19.98f, 4.606f, 20.076f)
                curveTo(4.82f, 20.185f, 5.1f, 20.185f, 5.66f, 20.185f)
                horizontalLineTo(11.146f)
                verticalLineTo(5.815f)
                close()
            }
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(9.349f, 8.169f)
                curveTo(9.349f, 8.39f, 9.349f, 8.501f, 9.318f, 8.59f)
                curveTo(9.262f, 8.753f, 9.134f, 8.882f, 8.97f, 8.938f)
                curveTo(8.881f, 8.969f, 8.771f, 8.969f, 8.549f, 8.969f)
                horizontalLineTo(6.636f)
                curveTo(6.414f, 8.969f, 6.304f, 8.969f, 6.214f, 8.938f)
                curveTo(6.051f, 8.882f, 5.923f, 8.753f, 5.866f, 8.59f)
                curveTo(5.836f, 8.501f, 5.836f, 8.39f, 5.836f, 8.169f)
                curveTo(5.836f, 7.948f, 5.836f, 7.837f, 5.866f, 7.748f)
                curveTo(5.923f, 7.584f, 6.051f, 7.456f, 6.214f, 7.4f)
                curveTo(6.304f, 7.369f, 6.414f, 7.369f, 6.636f, 7.369f)
                horizontalLineTo(8.549f)
                curveTo(8.771f, 7.369f, 8.881f, 7.369f, 8.97f, 7.4f)
                curveTo(9.134f, 7.456f, 9.262f, 7.584f, 9.318f, 7.748f)
                curveTo(9.349f, 7.837f, 9.349f, 7.948f, 9.349f, 8.169f)
                close()
            }
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(9.349f, 11.331f)
                curveTo(9.349f, 11.552f, 9.349f, 11.663f, 9.318f, 11.752f)
                curveTo(9.262f, 11.916f, 9.134f, 12.044f, 8.97f, 12.1f)
                curveTo(8.881f, 12.131f, 8.771f, 12.131f, 8.549f, 12.131f)
                horizontalLineTo(6.636f)
                curveTo(6.414f, 12.131f, 6.304f, 12.131f, 6.214f, 12.1f)
                curveTo(6.051f, 12.044f, 5.923f, 11.916f, 5.866f, 11.752f)
                curveTo(5.836f, 11.663f, 5.836f, 11.552f, 5.836f, 11.331f)
                curveTo(5.836f, 11.11f, 5.836f, 10.999f, 5.866f, 10.91f)
                curveTo(5.923f, 10.747f, 6.051f, 10.618f, 6.214f, 10.562f)
                curveTo(6.304f, 10.531f, 6.414f, 10.531f, 6.636f, 10.531f)
                horizontalLineTo(8.549f)
                curveTo(8.771f, 10.531f, 8.881f, 10.531f, 8.97f, 10.562f)
                curveTo(9.134f, 10.618f, 9.262f, 10.747f, 9.318f, 10.91f)
                curveTo(9.349f, 10.999f, 9.349f, 11.11f, 9.349f, 11.331f)
                close()
            }
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(5.836f, 14.493f)
                curveTo(5.836f, 14.715f, 5.836f, 14.825f, 5.866f, 14.914f)
                curveTo(5.923f, 15.078f, 6.051f, 15.206f, 6.214f, 15.262f)
                curveTo(6.304f, 15.293f, 6.414f, 15.293f, 6.636f, 15.293f)
                horizontalLineTo(8.549f)
                curveTo(8.771f, 15.293f, 8.881f, 15.293f, 8.97f, 15.262f)
                curveTo(9.134f, 15.206f, 9.262f, 15.078f, 9.318f, 14.914f)
                curveTo(9.349f, 14.825f, 9.349f, 14.715f, 9.349f, 14.493f)
                curveTo(9.349f, 14.272f, 9.349f, 14.161f, 9.318f, 14.072f)
                curveTo(9.262f, 13.909f, 9.134f, 13.78f, 8.97f, 13.724f)
                curveTo(8.881f, 13.693f, 8.771f, 13.693f, 8.549f, 13.693f)
                horizontalLineTo(6.636f)
                curveTo(6.414f, 13.693f, 6.304f, 13.693f, 6.214f, 13.724f)
                curveTo(6.051f, 13.78f, 5.923f, 13.909f, 5.866f, 14.072f)
                curveTo(5.836f, 14.161f, 5.836f, 14.272f, 5.836f, 14.493f)
                close()
            }
        }.build()
        return _navigatorSwitch!!
    }

private var _navigatorSwitch: ImageVector? = null