// Copyright 2025, miuix-kotlin-multiplatform contributors
// SPDX-License-Identifier: Apache-2.0

package top.yukonga.miuix.kmp.icon.icons.useful

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import top.yukonga.miuix.kmp.icon.MiuixIcons

val MiuixIcons.Useful.Order: ImageVector
    get() {
        if (_order != null) {
            return _order!!
        }
        _order = ImageVector.Builder("Order", 26.0.dp, 26.0.dp, 26.0f, 26.0f).apply {
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(8.814f, 8.941f)
                curveTo(8.784f, 8.852f, 8.784f, 8.742f, 8.784f, 8.52f)
                curveTo(8.784f, 8.299f, 8.784f, 8.188f, 8.814f, 8.099f)
                curveTo(8.871f, 7.936f, 8.999f, 7.807f, 9.163f, 7.751f)
                curveTo(9.252f, 7.72f, 9.362f, 7.72f, 9.584f, 7.72f)
                horizontalLineTo(16.416f)
                curveTo(16.638f, 7.72f, 16.748f, 7.72f, 16.837f, 7.751f)
                curveTo(17.001f, 7.807f, 17.129f, 7.936f, 17.185f, 8.099f)
                curveTo(17.216f, 8.188f, 17.216f, 8.299f, 17.216f, 8.52f)
                curveTo(17.216f, 8.742f, 17.216f, 8.852f, 17.185f, 8.941f)
                curveTo(17.129f, 9.105f, 17.001f, 9.233f, 16.837f, 9.29f)
                curveTo(16.748f, 9.32f, 16.638f, 9.32f, 16.416f, 9.32f)
                horizontalLineTo(9.584f)
                curveTo(9.362f, 9.32f, 9.252f, 9.32f, 9.163f, 9.29f)
                curveTo(8.999f, 9.233f, 8.871f, 9.105f, 8.814f, 8.941f)
                close()
            }
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(8.815f, 12.719f)
                curveTo(8.784f, 12.629f, 8.784f, 12.519f, 8.784f, 12.297f)
                curveTo(8.784f, 12.076f, 8.784f, 11.965f, 8.815f, 11.876f)
                curveTo(8.871f, 11.713f, 8.999f, 11.584f, 9.163f, 11.528f)
                curveTo(9.252f, 11.497f, 9.362f, 11.497f, 9.584f, 11.497f)
                horizontalLineTo(13.605f)
                curveTo(13.827f, 11.497f, 13.938f, 11.497f, 14.027f, 11.528f)
                curveTo(14.19f, 11.584f, 14.318f, 11.713f, 14.375f, 11.876f)
                curveTo(14.405f, 11.965f, 14.405f, 12.076f, 14.405f, 12.297f)
                curveTo(14.405f, 12.519f, 14.405f, 12.629f, 14.375f, 12.719f)
                curveTo(14.318f, 12.882f, 14.19f, 13.01f, 14.027f, 13.067f)
                curveTo(13.938f, 13.097f, 13.827f, 13.097f, 13.605f, 13.097f)
                horizontalLineTo(9.584f)
                curveTo(9.362f, 13.097f, 9.252f, 13.097f, 9.163f, 13.067f)
                curveTo(8.999f, 13.01f, 8.871f, 12.882f, 8.815f, 12.719f)
                close()
            }
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(17.334f, 21.666f)
                lineTo(19.558f, 19.442f)
                curveTo(19.99f, 19.01f, 20.207f, 18.793f, 20.361f, 18.541f)
                curveTo(20.498f, 18.317f, 20.599f, 18.073f, 20.661f, 17.818f)
                curveTo(20.691f, 17.693f, 20.708f, 17.564f, 20.717f, 17.408f)
                horizontalLineTo(20.73f)
                lineTo(20.73f, 7.162f)
                curveTo(20.73f, 5.762f, 20.73f, 5.062f, 20.457f, 4.527f)
                curveTo(20.218f, 4.057f, 19.835f, 3.674f, 19.365f, 3.435f)
                curveTo(18.83f, 3.162f, 18.13f, 3.162f, 16.73f, 3.162f)
                horizontalLineTo(9.27f)
                curveTo(7.87f, 3.162f, 7.17f, 3.162f, 6.635f, 3.435f)
                curveTo(6.165f, 3.674f, 5.782f, 4.057f, 5.543f, 4.527f)
                curveTo(5.27f, 5.062f, 5.27f, 5.762f, 5.27f, 7.162f)
                verticalLineTo(18.838f)
                curveTo(5.27f, 20.238f, 5.27f, 20.938f, 5.543f, 21.473f)
                curveTo(5.782f, 21.943f, 6.165f, 22.326f, 6.635f, 22.565f)
                curveTo(7.17f, 22.838f, 7.87f, 22.838f, 9.27f, 22.838f)
                horizontalLineTo(15.3f)
                verticalLineTo(22.825f)
                curveTo(15.456f, 22.816f, 15.585f, 22.799f, 15.71f, 22.769f)
                curveTo(15.965f, 22.708f, 16.209f, 22.607f, 16.433f, 22.469f)
                curveTo(16.685f, 22.315f, 16.901f, 22.099f, 17.334f, 21.666f)
                close()
                moveTo(19.102f, 17.441f)
                curveTo(19.105f, 17.43f, 19.107f, 17.419f, 19.11f, 17.408f)
                horizontalLineTo(16.9f)
                curveTo(16.34f, 17.408f, 16.06f, 17.408f, 15.846f, 17.517f)
                curveTo(15.658f, 17.612f, 15.505f, 17.765f, 15.409f, 17.954f)
                curveTo(15.3f, 18.167f, 15.3f, 18.448f, 15.3f, 19.008f)
                verticalLineTo(21.215f)
                curveTo(15.312f, 21.213f, 15.324f, 21.21f, 15.336f, 21.207f)
                curveTo(15.438f, 21.183f, 15.535f, 21.142f, 15.625f, 21.088f)
                curveTo(15.726f, 21.026f, 15.812f, 20.939f, 15.985f, 20.766f)
                lineTo(18.661f, 18.09f)
                curveTo(18.834f, 17.917f, 18.921f, 17.83f, 18.983f, 17.73f)
                curveTo(19.038f, 17.64f, 19.078f, 17.543f, 19.102f, 17.441f)
                close()
                moveTo(8.47f, 21.235f)
                horizontalLineTo(13.703f)
                verticalLineTo(19.811f)
                curveTo(13.703f, 18.411f, 13.703f, 17.711f, 13.975f, 17.176f)
                curveTo(14.215f, 16.705f, 14.597f, 16.323f, 15.068f, 16.083f)
                curveTo(15.602f, 15.811f, 16.303f, 15.811f, 17.703f, 15.811f)
                horizontalLineTo(19.13f)
                verticalLineTo(6.365f)
                curveTo(19.13f, 5.805f, 19.13f, 5.525f, 19.021f, 5.311f)
                curveTo(18.925f, 5.123f, 18.772f, 4.97f, 18.584f, 4.874f)
                curveTo(18.37f, 4.765f, 18.09f, 4.765f, 17.53f, 4.765f)
                horizontalLineTo(8.47f)
                curveTo(7.91f, 4.765f, 7.63f, 4.765f, 7.416f, 4.874f)
                curveTo(7.228f, 4.97f, 7.075f, 5.123f, 6.979f, 5.311f)
                curveTo(6.87f, 5.525f, 6.87f, 5.805f, 6.87f, 6.365f)
                verticalLineTo(19.635f)
                curveTo(6.87f, 20.195f, 6.87f, 20.475f, 6.979f, 20.689f)
                curveTo(7.075f, 20.877f, 7.228f, 21.03f, 7.416f, 21.126f)
                curveTo(7.63f, 21.235f, 7.91f, 21.235f, 8.47f, 21.235f)
                close()
            }
        }.build()
        return _order!!
    }

private var _order: ImageVector? = null