// Copyright 2025, miuix-kotlin-multiplatform contributors
// SPDX-License-Identifier: Apache-2.0

package top.yukonga.miuix.kmp.icon.icons.useful

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import top.yukonga.miuix.kmp.icon.MiuixIcons

val MiuixIcons.Useful.Stick: ImageVector
    get() {
        if (_stick != null) return _stick!!
        _stick = ImageVector.Builder("Stick", 26.0.dp, 26.0.dp, 26.0f, 26.0f).apply {
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(9.704f, 16.253f)
                curveTo(9.548f, 16.096f, 9.47f, 16.018f, 9.385f, 15.977f)
                curveTo(9.229f, 15.901f, 9.048f, 15.901f, 8.893f, 15.977f)
                curveTo(8.808f, 16.018f, 8.73f, 16.096f, 8.573f, 16.253f)
                lineTo(4.508f, 20.318f)
                curveTo(4.351f, 20.475f, 4.273f, 20.553f, 4.232f, 20.638f)
                curveTo(4.156f, 20.793f, 4.156f, 20.975f, 4.232f, 21.13f)
                curveTo(4.273f, 21.215f, 4.351f, 21.293f, 4.508f, 21.449f)
                curveTo(4.664f, 21.606f, 4.743f, 21.684f, 4.827f, 21.726f)
                curveTo(4.983f, 21.801f, 5.164f, 21.801f, 5.32f, 21.726f)
                curveTo(5.404f, 21.684f, 5.483f, 21.606f, 5.639f, 21.449f)
                lineTo(9.704f, 17.384f)
                curveTo(9.861f, 17.228f, 9.939f, 17.149f, 9.981f, 17.065f)
                curveTo(10.056f, 16.909f, 10.056f, 16.728f, 9.981f, 16.573f)
                curveTo(9.939f, 16.488f, 9.861f, 16.41f, 9.704f, 16.253f)
                close()
            }
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(23.069f, 9.253f)
                curveTo(23.226f, 9.409f, 23.304f, 9.488f, 23.345f, 9.572f)
                curveTo(23.421f, 9.728f, 23.421f, 9.909f, 23.345f, 10.065f)
                curveTo(23.304f, 10.149f, 23.226f, 10.228f, 23.069f, 10.384f)
                curveTo(22.913f, 10.541f, 22.834f, 10.619f, 22.75f, 10.66f)
                curveTo(22.594f, 10.736f, 22.413f, 10.736f, 22.257f, 10.66f)
                curveTo(22.173f, 10.619f, 22.094f, 10.541f, 21.938f, 10.384f)
                lineTo(21.431f, 9.878f)
                lineTo(18.985f, 12.651f)
                curveTo(18.834f, 12.821f, 18.759f, 12.906f, 18.717f, 12.997f)
                curveTo(18.676f, 13.084f, 18.657f, 13.157f, 18.651f, 13.253f)
                curveTo(18.645f, 13.353f, 18.673f, 13.478f, 18.73f, 13.729f)
                curveTo(19.23f, 15.949f, 18.823f, 18.316f, 17.503f, 20.233f)
                curveTo(17.285f, 20.549f, 17.176f, 20.707f, 16.981f, 20.799f)
                curveTo(16.826f, 20.873f, 16.599f, 20.893f, 16.434f, 20.849f)
                curveTo(16.226f, 20.794f, 16.068f, 20.636f, 15.752f, 20.321f)
                lineTo(5.679f, 10.248f)
                curveTo(5.364f, 9.932f, 5.206f, 9.774f, 5.151f, 9.566f)
                curveTo(5.107f, 9.401f, 5.127f, 9.174f, 5.201f, 9.019f)
                curveTo(5.293f, 8.824f, 5.451f, 8.715f, 5.767f, 8.497f)
                curveTo(7.684f, 7.177f, 10.052f, 6.77f, 12.271f, 7.27f)
                curveTo(12.522f, 7.327f, 12.648f, 7.355f, 12.748f, 7.349f)
                curveTo(12.843f, 7.343f, 12.917f, 7.324f, 13.003f, 7.284f)
                curveTo(13.094f, 7.241f, 13.179f, 7.166f, 13.35f, 7.016f)
                lineTo(16.122f, 4.569f)
                lineTo(15.616f, 4.062f)
                curveTo(15.459f, 3.906f, 15.381f, 3.827f, 15.34f, 3.743f)
                curveTo(15.264f, 3.587f, 15.264f, 3.406f, 15.34f, 3.25f)
                curveTo(15.381f, 3.166f, 15.459f, 3.087f, 15.616f, 2.931f)
                curveTo(15.772f, 2.774f, 15.851f, 2.696f, 15.935f, 2.655f)
                curveTo(16.091f, 2.579f, 16.272f, 2.579f, 16.428f, 2.655f)
                curveTo(16.512f, 2.696f, 16.591f, 2.774f, 16.747f, 2.931f)
                lineTo(23.069f, 9.253f)
                close()
                moveTo(17.249f, 5.696f)
                lineTo(14.785f, 7.881f)
                curveTo(14.283f, 8.327f, 14.031f, 8.55f, 13.804f, 8.666f)
                curveTo(13.531f, 8.805f, 13.467f, 8.825f, 13.163f, 8.867f)
                curveTo(12.91f, 8.901f, 12.36f, 8.835f, 11.258f, 8.703f)
                curveTo(10.004f, 8.553f, 8.723f, 8.753f, 7.572f, 9.303f)
                curveTo(7.45f, 9.362f, 7.389f, 9.391f, 7.358f, 9.441f)
                curveTo(7.332f, 9.483f, 7.322f, 9.539f, 7.333f, 9.588f)
                curveTo(7.345f, 9.646f, 7.396f, 9.696f, 7.496f, 9.796f)
                lineTo(16.204f, 18.504f)
                curveTo(16.304f, 18.604f, 16.354f, 18.655f, 16.412f, 18.667f)
                curveTo(16.461f, 18.678f, 16.517f, 18.668f, 16.559f, 18.642f)
                curveTo(16.609f, 18.611f, 16.638f, 18.55f, 16.697f, 18.428f)
                curveTo(17.247f, 17.277f, 17.447f, 15.996f, 17.297f, 14.742f)
                curveTo(17.165f, 13.641f, 17.099f, 13.09f, 17.133f, 12.837f)
                curveTo(17.175f, 12.533f, 17.195f, 12.469f, 17.334f, 12.196f)
                curveTo(17.45f, 11.969f, 17.673f, 11.717f, 18.119f, 11.215f)
                lineTo(20.305f, 8.751f)
                lineTo(17.249f, 5.696f)
                close()
            }
        }.build()
        return _stick!!
    }

private var _stick: ImageVector? = null