// Copyright 2025, miuix-kotlin-multiplatform contributors
// SPDX-License-Identifier: Apache-2.0

package top.yukonga.miuix.kmp.icon.icons.useful

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import top.yukonga.miuix.kmp.icon.MiuixIcons

val MiuixIcons.Useful.Unstick: ImageVector
    get() {
        if (_unstick != null) return _unstick!!
        _unstick = ImageVector.Builder("Unstick", 26.0.dp, 26.0.dp, 26.0f, 26.0f).apply {
            path(
                fill = SolidColor(Color.Black)
            ) {
                moveTo(13.0f, 17.211f)
                curveTo(12.779f, 17.211f, 12.668f, 17.211f, 12.579f, 17.242f)
                curveTo(12.415f, 17.298f, 12.287f, 17.426f, 12.231f, 17.59f)
                curveTo(12.2f, 17.679f, 12.2f, 17.789f, 12.2f, 18.011f)
                lineTo(12.2f, 22.998f)
                curveTo(12.2f, 23.219f, 12.2f, 23.33f, 12.231f, 23.419f)
                curveTo(12.287f, 23.582f, 12.415f, 23.711f, 12.579f, 23.767f)
                curveTo(12.668f, 23.798f, 12.779f, 23.798f, 13.0f, 23.798f)
                curveTo(13.221f, 23.798f, 13.332f, 23.798f, 13.421f, 23.767f)
                curveTo(13.585f, 23.711f, 13.713f, 23.582f, 13.769f, 23.419f)
                curveTo(13.8f, 23.33f, 13.8f, 23.219f, 13.8f, 22.998f)
                verticalLineTo(18.011f)
                curveTo(13.8f, 17.789f, 13.8f, 17.679f, 13.769f, 17.59f)
                curveTo(13.713f, 17.426f, 13.585f, 17.298f, 13.421f, 17.242f)
                curveTo(13.332f, 17.211f, 13.221f, 17.211f, 13.0f, 17.211f)
                close()
            }
            path(
                fill = SolidColor(Color.Black),
                pathFillType = PathFillType.EvenOdd
            ) {
                moveTo(17.47f, 2.811f)
                curveTo(17.692f, 2.811f, 17.802f, 2.811f, 17.892f, 2.842f)
                curveTo(18.055f, 2.898f, 18.183f, 3.026f, 18.24f, 3.19f)
                curveTo(18.27f, 3.279f, 18.27f, 3.389f, 18.27f, 3.611f)
                curveTo(18.27f, 3.832f, 18.27f, 3.943f, 18.24f, 4.032f)
                curveTo(18.183f, 4.195f, 18.055f, 4.324f, 17.892f, 4.38f)
                curveTo(17.802f, 4.411f, 17.692f, 4.411f, 17.47f, 4.411f)
                horizontalLineTo(16.754f)
                lineTo(16.985f, 8.102f)
                curveTo(16.999f, 8.329f, 17.006f, 8.442f, 17.04f, 8.536f)
                curveTo(17.073f, 8.626f, 17.111f, 8.691f, 17.175f, 8.763f)
                curveTo(17.241f, 8.838f, 17.35f, 8.907f, 17.567f, 9.045f)
                curveTo(19.491f, 10.26f, 20.876f, 12.222f, 21.298f, 14.511f)
                curveTo(21.368f, 14.889f, 21.403f, 15.078f, 21.33f, 15.28f)
                curveTo(21.272f, 15.442f, 21.126f, 15.617f, 20.978f, 15.703f)
                curveTo(20.792f, 15.811f, 20.569f, 15.811f, 20.123f, 15.811f)
                horizontalLineTo(5.877f)
                curveTo(5.431f, 15.811f, 5.208f, 15.811f, 5.022f, 15.703f)
                curveTo(4.873f, 15.617f, 4.728f, 15.442f, 4.67f, 15.28f)
                curveTo(4.597f, 15.078f, 4.632f, 14.889f, 4.702f, 14.511f)
                curveTo(5.124f, 12.221f, 6.51f, 10.26f, 8.433f, 9.044f)
                curveTo(8.651f, 8.907f, 8.759f, 8.838f, 8.826f, 8.763f)
                curveTo(8.889f, 8.691f, 8.928f, 8.626f, 8.96f, 8.536f)
                curveTo(8.994f, 8.441f, 9.001f, 8.328f, 9.016f, 8.102f)
                lineTo(9.246f, 4.411f)
                horizontalLineTo(8.53f)
                curveTo(8.308f, 4.411f, 8.198f, 4.411f, 8.108f, 4.38f)
                curveTo(7.945f, 4.324f, 7.817f, 4.195f, 7.76f, 4.032f)
                curveTo(7.73f, 3.943f, 7.73f, 3.832f, 7.73f, 3.611f)
                curveTo(7.73f, 3.389f, 7.73f, 3.279f, 7.76f, 3.19f)
                curveTo(7.817f, 3.026f, 7.945f, 2.898f, 8.108f, 2.842f)
                curveTo(8.198f, 2.811f, 8.308f, 2.811f, 8.53f, 2.811f)
                horizontalLineTo(17.47f)
                close()
                moveTo(10.84f, 4.411f)
                lineTo(10.643f, 7.699f)
                curveTo(10.603f, 8.369f, 10.583f, 8.705f, 10.504f, 8.947f)
                curveTo(10.41f, 9.239f, 10.378f, 9.299f, 10.192f, 9.543f)
                curveTo(10.038f, 9.745f, 9.602f, 10.088f, 8.73f, 10.774f)
                curveTo(7.737f, 11.554f, 6.972f, 12.601f, 6.548f, 13.804f)
                curveTo(6.503f, 13.932f, 6.48f, 13.996f, 6.494f, 14.053f)
                curveTo(6.505f, 14.102f, 6.538f, 14.148f, 6.58f, 14.175f)
                curveTo(6.63f, 14.207f, 6.701f, 14.207f, 6.843f, 14.207f)
                horizontalLineTo(19.157f)
                curveTo(19.299f, 14.207f, 19.37f, 14.207f, 19.42f, 14.175f)
                curveTo(19.462f, 14.148f, 19.494f, 14.102f, 19.506f, 14.053f)
                curveTo(19.52f, 13.996f, 19.497f, 13.932f, 19.452f, 13.804f)
                curveTo(19.028f, 12.602f, 18.263f, 11.554f, 17.27f, 10.774f)
                curveTo(16.398f, 10.088f, 15.962f, 9.745f, 15.808f, 9.543f)
                curveTo(15.622f, 9.299f, 15.591f, 9.239f, 15.496f, 8.947f)
                curveTo(15.418f, 8.704f, 15.398f, 8.369f, 15.357f, 7.699f)
                lineTo(15.161f, 4.411f)
                horizontalLineTo(10.84f)
                close()
            }
        }.build()
        return _unstick!!
    }

private var _unstick: ImageVector? = null