/*
 * Decompiled with CFR 0.152.
 */
package top.yumbo.util.music.annotation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import top.yumbo.util.music.MusicEnum;
import top.yumbo.util.music.annotation.MusicService;
import top.yumbo.util.music.musicAbstract.AbstractMusic;

public class YumboAnnotationUtils {
    public static void sendRequestAutowiredJson(Object obj) {
        if (obj == null) {
            throw new NullPointerException("\u704f\u4f7d\ue5ca\u7035\u7845\u8584\u6d93\u5d88\u5158\u6d93\u7c04ull");
        }
        Class<?> clazz = obj.getClass();
        if (obj instanceof AbstractMusic) {
            MusicService annotation;
            Method[] methods;
            AbstractMusic abstractMusic = (AbstractMusic)obj;
            String currentRunningMethod = abstractMusic.getCurrentRunningMethod();
            Method method = null;
            for (Method m : methods = clazz.getMethods()) {
                if (!m.getName().equals(currentRunningMethod)) continue;
                method = m;
            }
            if (method == null) {
                try {
                    throw new NoSuchMethodException();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if ((annotation = method.getAnnotation(MusicService.class)) != null) {
                String fullPathURL;
                String url = annotation.url();
                MusicEnum musicEnum = abstractMusic.getMusicEnum();
                if (musicEnum == MusicEnum.OtherMusic) {
                    String serverAddress = annotation.serverAddress();
                    fullPathURL = MusicEnum.OtherMusic.getFullPathURL(serverAddress, url);
                } else {
                    fullPathURL = musicEnum.getFullPathURL(null, url);
                }
                if (abstractMusic.getParameter() == null) {
                    abstractMusic.setParameter(new JSONObject());
                }
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.setContentType(MediaType.APPLICATION_JSON);
                String cookie = abstractMusic.getCookieString();
                if (cookie == null) {
                    cookie = "";
                }
                httpHeaders.add("Cookie", cookie);
                HttpEntity stringHttpEntity = new HttpEntity((Object)abstractMusic.getParameter().toJSONString(), (MultiValueMap)httpHeaders);
                System.out.println("\u8930\u64b3\u58a0\u93b5\u0446\ue511:" + clazz.toString() + "." + method.getName() + "()\n\u7487\u950b\u7730\u9428\u52ed\u6d49\u7035\u7845\u77fe\u5bf0\ufffd:" + url);
                try {
                    List setCookie;
                    System.out.println("\u7f01\u6fc6\ue1ee\u74ba\ue21a\u7dde:" + fullPathURL);
                    long time = Timestamp.valueOf(LocalDateTime.now()).getTime();
                    fullPathURL = fullPathURL + "?timestamp=" + time;
                    ResponseEntity responseEntity = new RestTemplate().exchange(fullPathURL, HttpMethod.POST, stringHttpEntity, String.class, new Object[0]);
                    abstractMusic.setResult(JSONObject.parseObject((String)((String)responseEntity.getBody())));
                    HttpHeaders headers = responseEntity.getHeaders();
                    if (headers != null && (setCookie = headers.get((Object)"set-cookie")) != null) {
                        String cookieString = YumboAnnotationUtils.parseSetCookie(setCookie.toString());
                        abstractMusic.setCookieString(cookieString);
                        abstractMusic.setParameter(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static JSONObject getJsonObjectFromApi(String url) {
        String jsonString = (String)new RestTemplate().getForObject(url, String.class, new Object[0]);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        return jsonObject;
    }

    private static void replaceJsonObject(JSONObject source, JSON target) {
        if (source == null) {
            source = new JSONObject();
        }
        source.clear();
        Map map = (Map)JSON.parseObject((String)target.toString(), Map.class);
        source.putAll(map);
    }

    private static String parseSetCookie(String setCookie) {
        if (setCookie == null) {
            return "";
        }
        System.out.println("\u7459\uff46\u703d\u9353\u5cdcookie\u93c4\ufffd" + setCookie);
        String[] split = setCookie.split(";, ");
        Optional<String> cookieStringOptional = Arrays.stream(split).map(x -> x.split(";")[0] + "; ").reduce((x, y) -> x + y);
        String cookieString = cookieStringOptional.get() + "]";
        System.out.println("\u7459\uff46\u703d\u935a\u5dc6ookie\u93c4\ufffd:" + cookieString);
        return cookieString;
    }
}

