/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.starter.log.configurator.mvc.advice;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import top.zopx.starter.log.event.ErrorLogEvent;
import top.zopx.starter.log.util.SpringUtil;
import top.zopx.starter.tools.basic.R;
import top.zopx.starter.tools.exceptions.BusException;
import top.zopx.starter.tools.tools.web.GlobalUtil;
import top.zopx.starter.tools.tools.web.LogUtil;

@RestControllerAdvice
public class ExceptionAdvice {
    @ExceptionHandler(value={BusException.class})
    public R<String> handleBusException(BusException e) {
        LogUtil.getInstance(ExceptionAdvice.class).error("BusException\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getMessage()});
        this.publish((Throwable)e);
        return R.failure((String)e.getMsg(), (Integer)e.getCode());
    }

    @ExceptionHandler(value={Exception.class})
    public R<String> handleException(Exception e) {
        LogUtil.getInstance(ExceptionAdvice.class).error("\u901a\u7528\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getMessage()});
        this.publish(e);
        return R.failure((String)e.getMessage(), (Integer)HttpStatus.BAD_REQUEST.value());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public R<String> handleValidationException(MethodArgumentNotValidException e) {
        LogUtil.getInstance(ExceptionAdvice.class).error("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getMessage()});
        this.publish((Throwable)e);
        return R.failure((String)((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage(), (Integer)HttpStatus.FORBIDDEN.value());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public R<String> handleValidationException(ConstraintViolationException e) {
        LogUtil.getInstance(ExceptionAdvice.class).error("\u6821\u9a8c\u53c2\u6570\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getMessage()});
        this.publish((Throwable)e);
        return R.failure((String)e.getMessage(), (Integer)HttpStatus.FORBIDDEN.value());
    }

    @ExceptionHandler(value={BindException.class})
    public R<String> handleValidationException(BindException e) {
        LogUtil.getInstance(ExceptionAdvice.class).error("\u6821\u9a8c\u53c2\u6570\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{e.getMessage()});
        HashMap<CallSite, String> errorMap = new HashMap<CallSite, String>();
        for (ObjectError error : e.getBindingResult().getAllErrors()) {
            FieldError fieldError = (FieldError)error;
            errorMap.put((CallSite)((Object)(fieldError.getObjectName() + "." + fieldError.getField())), error.getDefaultMessage());
        }
        this.publish((Throwable)e);
        return R.failure((String)SpringUtil.getJson().toJson(errorMap), (Integer)HttpStatus.FORBIDDEN.value());
    }

    @ExceptionHandler(value={Throwable.class})
    public R<String> handleValidationException(Throwable e) {
        this.publish(e);
        return R.failure((String)e.getMessage(), (Integer)HttpStatus.BAD_REQUEST.value());
    }

    public void publish(Throwable e) {
        HttpServletRequest request = GlobalUtil.Request.getRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtils.isNotEmpty((Object)e)) {
            map.put("stackTrace", this.printStackTraceToString(e));
            map.put("exceptionName", e.getClass().getName());
            map.put("message", e.getMessage());
            StackTraceElement[] elements = e.getStackTrace();
            if (ObjectUtils.isNotEmpty((Object)elements)) {
                StackTraceElement element = elements[0];
                map.put("methodName", element.getMethodName());
                map.put("className", element.getClassName());
                map.put("fileName", element.getFileName());
                map.put("lineNumber", element.getLineNumber());
            }
        }
        SpringUtil.addRequestInfo(request, map);
        SpringUtil.publishEvent(new ErrorLogEvent(map));
    }

    public String printStackTraceToString(Throwable t) {
        String string;
        StringWriter sw = new StringWriter();
        try {
            t.printStackTrace(new PrintWriter((Writer)sw, true));
            string = sw.getBuffer().toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        sw.close();
        return string;
    }
}

