/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.starter.log.configurator.mvc.aspect;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import top.zopx.starter.log.annotations.OperatorLogAnnotation;
import top.zopx.starter.log.event.ApiLogEvent;
import top.zopx.starter.log.util.SpringUtil;
import top.zopx.starter.tools.tools.web.GlobalUtil;

@Aspect
@Order(value=1)
public class ApiLogAspect {
    @Pointcut(value="@annotation(top.zopx.starter.log.annotations.OperatorLogAnnotation)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        map.put("params", SpringUtil.getJson().toJson((Object)joinPoint.getArgs()));
        map.put("className", signature.getDeclaringTypeName());
        map.put("methodName", signature.getName());
        map.put("value", signature.getMethod().getDeclaredAnnotation(OperatorLogAnnotation.class).value());
        long startTime = System.currentTimeMillis();
        Object result = joinPoint.proceed();
        map.put("execTime", System.currentTimeMillis() - startTime);
        this.publish(map, result);
        return result;
    }

    public void publish(Map<String, Object> map, Object result) {
        SpringUtil.addRequestInfo(GlobalUtil.Request.getRequest(), map);
        map.put("result", SpringUtil.getJson().toJson(result));
        SpringUtil.publishEvent(new ApiLogEvent(map));
    }
}

