/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.starter.log.event.listener;

import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import top.zopx.starter.log.configurator.properties.SquareLogProperties;
import top.zopx.starter.log.event.ApiLogEvent;
import top.zopx.starter.log.event.ErrorLogEvent;
import top.zopx.starter.log.service.ILogService;

@Component
public class PublishEventListener {
    @Resource
    private ILogService logService;
    @Resource
    private SquareLogProperties squareLogProperties;

    @EventListener(value={ErrorLogEvent.class})
    public void onApplicationEvent(ErrorLogEvent event) {
        Map source = (Map)event.getSource();
        source.put("appName", this.squareLogProperties.getAppName());
        this.logService.saveError(source);
    }

    @EventListener(value={ApiLogEvent.class})
    public void onApplicationEvent(ApiLogEvent event) {
        Map source = (Map)event.getSource();
        source.put("appName", this.squareLogProperties.getAppName());
        this.logService.saveApi(source);
    }
}

