/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.starter.log.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import top.zopx.starter.tools.tools.date.LocalDateUtil;
import top.zopx.starter.tools.tools.json.IJson;
import top.zopx.starter.tools.tools.json.JsonUtil;
import top.zopx.starter.tools.tools.web.GlobalUtil;
import top.zopx.starter.tools.tools.web.LogUtil;

@Component
public class SpringUtil
implements ApplicationContextAware {
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)(clazz == null ? null : context.getBean(clazz));
    }

    public static <T> T getBean(String beanName, Class<T> clazz) {
        if (null != beanName && !"".equals(beanName.trim())) {
            return (T)(clazz == null ? null : context.getBean(beanName, clazz));
        }
        return null;
    }

    public static IJson getJson() {
        return Optional.ofNullable(SpringUtil.getBean(IJson.class)).orElse(JsonUtil.getInstance().getJson());
    }

    public static void publishEvent(ApplicationEvent event) {
        if (context != null) {
            try {
                context.publishEvent(event);
            }
            catch (Exception e) {
                LogUtil.getInstance(SpringUtil.class).error(e.getMessage());
            }
        }
    }

    public static void addRequestInfo(HttpServletRequest request, Map<String, Object> map) {
        map.put("requestUrl", SpringUtil.getPath(request.getRequestURI()));
        map.put("ip", GlobalUtil.Request.getBrowserIp((HttpServletRequest)request));
        map.put("agent", GlobalUtil.Request.getBrowserAgent((HttpServletRequest)request));
        map.put("reference", GlobalUtil.Request.getBrowserRefer((HttpServletRequest)request));
        map.put("createTime", LocalDateUtil.INSTANCE.nowDateTime());
        map.put("requestType", request.getMethod());
    }

    public static String getPath(String uriStr) {
        URI uri;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException var3) {
            throw new RuntimeException(var3);
        }
        return uri.getPath();
    }
}

