/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorOutputStream;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybBinaryLob
extends SybLob
implements Blob {
    private static Logger LOG = Logger.getLogger(SybBinaryLob.class.getName());
    private static volatile long _logIdCounter = 0L;

    public SybBinaryLob(String string, ProtocolContext protocolContext, byte[] byArray) throws SQLException {
        super(string, protocolContext, byArray);
        this._lobType = SybLob.LOB_TYPE.IMAGE;
        this.setLiteralSQL();
        this._lengthBuiltin = "datalength";
        this._logId = string + "_Bl" + _logIdCounter++;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getBinaryStream()");
        }
        return new LobLocatorBufferedInputStream(new LobLocatorInputStream(this), 16384);
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBinaryStream(long = [" + l + "], long = [" + l2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBinaryStream(long, long)");
            }
        }
        long l3 = this.length();
        if (l < 1L || l > l3 || l + l2 > l3 + 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        return new LobLocatorBufferedInputStream(new LobLocatorInputStream(this, l, l2), 16384);
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBytes(long = [" + l + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBytes(long, int)");
            }
        }
        this.checkLocatorValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        } else if (n < 0) {
            ErrorMessage.raiseError("JZ038");
        }
        MdaManager mdaManager = this._context._conn.getMDA(this._context);
        PreparedStatement preparedStatement = mdaManager.getMetaDataAccessor("LOB_GETBYTES", this._context);
        preparedStatement.setInt(1, this._lobType.ordinal());
        preparedStatement.setBytes(2, this.getLocator());
        preparedStatement.setLong(3, l);
        preparedStatement.setInt(4, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            byte[] byArray = resultSet.getBytes(1);
            int n2 = resultSet.getInt(2);
            if (byArray != null) {
                return byArray;
            }
            if (n2 != 0 && l <= (long)n2) {
                return new byte[0];
            }
        }
        return null;
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " position", new Object[]{byArray, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " position", new Object[]{byArray, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(byte[], long)");
            }
        }
        this.checkLocatorValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        long l2 = -1L;
        if (byArray != null) {
            CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("SEARCH_LOB", this._context);
            callableStatement.setInt(1, this._lobType.ordinal());
            callableStatement.setBytes(2, byArray);
            callableStatement.setBytes(3, this.getLocator());
            callableStatement.setLong(4, l);
            callableStatement.registerOutParameter(5, -5);
            callableStatement.setInt(6, 1);
            callableStatement.setNull(7, 12);
            callableStatement.execute();
            l2 = callableStatement.getLong(5);
            if (l2 < l) {
                l2 = -1L;
            }
        }
        return l2;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " position", new Object[]{blob, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " position", new Object[]{blob, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(Blob, long)");
            }
        }
        return super.searchLocator((SybLob)((Object)blob), l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBytes", new Object[]{l, byArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBytes", new Object[]{l, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBytes(long, byte[])");
            }
        }
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        int n = 0;
        if (byArray != null) {
            this.checkLocatorValidity();
            CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("IMAGE_SETDATA", this._context);
            callableStatement.setBytes(1, this.getLocator());
            callableStatement.setLong(2, l);
            callableStatement.setBytes(3, byArray);
            callableStatement.registerOutParameter(4, 4);
            callableStatement.execute();
            n = callableStatement.getInt(4);
            if (n == 0 && byArray.length != 0) {
                ErrorMessage.raiseError("JZ037");
            }
        }
        return n;
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBytes", new Object[]{l, byArray, n, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBytes", new Object[]{l, byArray, n, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBytes(long, byte[], int, int)");
            }
        }
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n - 1, byArray2, 0, n2);
            return this.setBytes(l, byArray2);
        }
        return 0;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setBinaryStream(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(long)");
            }
        }
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedOutputStream(new LobLocatorOutputStream(this, l), 16384);
    }
}

