/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.DynamicClassLoader;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LoaderConnection;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.SybConnection;
import com.sybase.jdbc4.jdbc.SybDebug;
import com.sybase.jdbc4.jdbc.SybJndiProvider;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybSqlIniProvider;
import com.sybase.jdbc4.jdbc.SybUrlManager;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.utils.EncryptedValue;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbc4.utils.SybVersion;
import com.sybase.jdbcx.Debug;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybDriver
implements com.sybase.jdbcx.SybDriver {
    private static Logger LOG = Logger.getLogger(SybDriver.class.getName());
    private static volatile long _logIdCounter = 0L;
    protected static final int HIGHEST_JCONNECT_VERSION = 100;
    public static final int DEFAULT_DRIVER_VERSION = 99;
    protected int _version = 99;
    private transient SybMessageHandler _msgHandler;
    private String _logId = "Dr" + _logIdCounter++;

    public SybDriver() {
        this.registerWithDriverManager();
    }

    @Override
    public final Connection connect(String string, Properties properties) throws SQLException {
        SQLWarning sQLWarning;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " connect", new Object[]{string, properties}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " connect", new Object[]{string, properties}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " connect(String, Properties)");
            }
        }
        SybProperty sybProperty = null;
        sybProperty = this._version == 0 || this._version == 99 || this._version == 100 ? new SybProperty(properties, 7) : new SybProperty(properties, this._version);
        SybUrlManager sybUrlManager = new SybUrlManager(string, properties, sybProperty);
        SybUrlProvider sybUrlProvider = sybUrlManager.getUrlProvider();
        if (sybUrlProvider == null) {
            return null;
        }
        SybConnection sybConnection = new SybConnection(this._logId, sybUrlProvider, string);
        if (this._msgHandler != null) {
            sybConnection.setSybMessageHandler(this._msgHandler);
        }
        if ((sQLWarning = sybProperty.getWarnings()) != null) {
            sybConnection.handleSQLE(sQLWarning);
        }
        return sybConnection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        SybUrlManager sybUrlManager;
        SybUrlProvider sybUrlProvider;
        int n;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + "acceptsURL(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + "acceptsURL(String)");
            }
        }
        if ((n = string.indexOf(47)) != -1) {
            string = string.substring(0, n);
        }
        if ((sybUrlProvider = (sybUrlManager = new SybUrlManager(string, null, null)).getUrlProvider()) == null) {
            return false;
        }
        if (sybUrlProvider instanceof SybJndiProvider || sybUrlProvider instanceof SybSqlIniProvider) {
            return true;
        }
        Protocol protocol = sybUrlProvider.getProtocol();
        return protocol != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2;
        int n;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " getPropertyInfo", new Object[]{string, properties}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getPropertyInfo", new Object[]{string, properties}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + "getPropertyInfo(String, java.util.Properties)");
            }
        }
        SybProperty sybProperty = null;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[107];
        sybProperty = this._version == 0 || this._version == 99 || this._version == 100 ? new SybProperty(properties, 7) : new SybProperty(properties, this._version);
        if (string != null && (n = string.indexOf(63)) > 0 && n++ < string.length()) {
            sybProperty.parsePropertyString(string.substring(n));
        }
        for (n = 0; n < 107; ++n) {
            driverPropertyInfoArray[n] = new DriverPropertyInfo(SybProperty.PROPNAME[n], null == sybProperty._propValue[n] ? null : sybProperty._propValue[n].toString());
            driverPropertyInfoArray[n].required = false;
            driverPropertyInfoArray[n].description = sybProperty.getPropertyDescription(SybProperty.PROPNAME[n]);
        }
        driverPropertyInfoArray[3].required = true;
        driverPropertyInfoArray[4].required = true;
        driverPropertyInfoArray[11].value = "";
        if (driverPropertyInfoArray[12].value.equals("0")) {
            driverPropertyInfoArray[12].value = "512";
        }
        if ((string2 = driverPropertyInfoArray[22].value.toString()).length() > 1) {
            if (string2.substring(2, string2.length()).equals("0")) {
                driverPropertyInfoArray[22].value = string2.substring(0, 1);
            }
        } else if (string2.equals("0")) {
            driverPropertyInfoArray[22].value = String.valueOf(7);
        }
        driverPropertyInfoArray[10].value = driverPropertyInfoArray[10].value + "\n\nConfidential property of SAP AG or an SAP affiliate company.\nCopyright (c) 2013\nSAP AG or an SAP affiliate company.  All rights reserved.\nUnpublished rights reserved under U.S. copyright laws.\nThis software contains confidential and trade secret information of SAP AG or\nan SAP affiliate company.   Use, duplication or disclosure of the software and\ndocumentation by the  U.S.  Government  is  subject  to  restrictions set forth in\na license agreement  between  the  Government  and SAP AG or an SAP affiliate\ncompany,  or  other  written agreement  specifying  the  Government's rights to\nuse the software and any applicable FAR provisions, for example, FAR 52.227-19.\nSAP AG or an SAP affiliate company\n";
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + "getMajorVersion()");
        }
        return SybVersion.MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + "getMinorVersion()");
        }
        return SybVersion.MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + "jdbcComliant()");
        }
        return false;
    }

    @Override
    public void setVersion(int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this._version = n;
                return;
            }
            case 0: {
                this._version = 100;
                return;
            }
        }
        ErrorMessage.raiseError("JZ0D6", "" + n);
    }

    @Override
    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._msgHandler = sybMessageHandler;
    }

    @Override
    public SybMessageHandler getSybMessageHandler() {
        return this._msgHandler;
    }

    public void setMessageHandler(SybMessageHandler sybMessageHandler) {
        this.setSybMessageHandler(sybMessageHandler);
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    @Override
    public final Debug getDebug() {
        return new SybDebug();
    }

    @Override
    public final void setRemotePassword(String string, String string2, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = SybProperty.PROPNAME[9];
        Object object = properties.get(string3);
        if (object != null && object instanceof EncryptedValue) {
            stringBuffer.append(((EncryptedValue)object).getValue());
        } else if (object != null) {
            stringBuffer.append(object);
        }
        stringBuffer.append(',');
        if (string != null) {
            stringBuffer.append(SybDriver.escapeSpecialCharacters(string));
        }
        stringBuffer.append(',');
        if (string2 != null) {
            stringBuffer.append(SybDriver.escapeSpecialCharacters(string2));
        }
        properties.put(string3, new EncryptedValue(stringBuffer.toString()));
    }

    private static StringBuffer escapeSpecialCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '\\' || c == ',') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    @Override
    public com.sybase.jdbcx.DynamicClassLoader getClassLoader(String string, Properties properties) {
        LoaderConnection loaderConnection = new LoaderConnection(this, string, properties);
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(loaderConnection);
        return dynamicClassLoader;
    }

    protected final SybConnection connect(String string, SybUrlProvider sybUrlProvider, int n) throws SQLException {
        SQLWarning sQLWarning;
        SybConnection sybConnection = this.createConnection(string, sybUrlProvider, n);
        if (this._msgHandler != null) {
            sybConnection.setSybMessageHandler(this._msgHandler);
        }
        if ((sQLWarning = sybUrlProvider.getSybProperty().getWarnings()) != null) {
            sybConnection.handleSQLE(sQLWarning);
        }
        return sybConnection;
    }

    protected final Connection connect(SybUrlProvider sybUrlProvider, int n) throws SQLException {
        return this.connect(null, sybUrlProvider, n);
    }

    protected SybConnection createConnection(String string, SybUrlProvider sybUrlProvider, int n) throws SQLException {
        Protocol protocol;
        SybConnection sybConnection = null;
        if (sybUrlProvider != null && (protocol = sybUrlProvider.getProtocol()) != null) {
            sybConnection = new SybConnection(this._logId, sybUrlProvider, string, n);
        }
        return sybConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithDriverManager() {
        try {
            Class<DriverManager> clazz = DriverManager.class;
            synchronized (DriverManager.class) {
                DriverManager.registerDriver(this);
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                while (enumeration.hasMoreElements()) {
                    Driver driver = enumeration.nextElement();
                    if (!(driver instanceof com.sybase.jdbcx.SybDriver) || driver == this) continue;
                    DriverManager.deregisterDriver(driver);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        {
            return;
        }
    }

    static {
        new SybDriver();
    }
}

