/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.LanguageToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;

public class SrvLanguageToken
extends LanguageToken
implements Dumpable {
    protected long _totalLen;

    public SrvLanguageToken(String string, boolean bl) {
        super(string, bl, false);
        this._totalLen = string.length() + 1;
    }

    public SrvLanguageToken(TdsInputStream tdsInputStream) throws IOException {
        this._totalLen = tdsInputStream.readInt();
        this._status = tdsInputStream.readUnsignedByte();
        this._query = tdsInputStream.readString((int)this._totalLen - 1);
    }

    public boolean hasParams() {
        return (this._status & 1) != 0;
    }

    public String getLanguage() {
        return this._query;
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(33)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "LANGUAGE Token (0x" + HexConverts.hexConvert(33, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "LANGUAGE Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 4, this._totalLen);
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(2)) {
                String[] stringArray = new String[]{"UNUSED", "PARAMETERIZED", "UNUSED", "LANGUAGE_BATCH"};
                dumpInfo.addBitfield("Status", 1, this._status, stringArray);
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Text Length", 0, this._totalLen - 1L);
                }
                dumpInfo.addText("Text", this._query.length(), this._query);
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 33;
    }
}

