/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;

public class SrvOffsetToken
extends Token
implements Dumpable {
    public static final int TDS_OFF_SELECT = 365;
    public static final int TDS_OFF_FROM = 335;
    public static final int TDS_OFF_ORDER = 357;
    public static final int TDS_OFF_COMPUTE = 313;
    public static final int TDS_OFF_TABLE = 371;
    public static final int TDS_OFF_PROC = 362;
    public static final int TDS_OFF_STMT = 459;
    public static final int TDS_OFF_PARAM = 452;
    private int _keyword;
    private int _offset;

    public SrvOffsetToken(TdsInputStream tdsInputStream) throws IOException {
        this._keyword = tdsInputStream.readShort();
        this._offset = tdsInputStream.readShort();
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(120)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "OFFSET Token (0x" + HexConverts.hexConvert(120, 1) + "); fixed length.");
            } else {
                dumpInfo.addInfo("Token", 1, "OFFSET Token");
            }
            if (dumpFilter.includesDetail(3)) {
                dumpInfo.addInfo("Keyword", 2, this.getKeywordString(this._keyword));
                dumpInfo.addInt("Offset", 2, this._offset);
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 120;
    }

    private String getKeywordString(int n) {
        String string;
        switch (n) {
            case 365: {
                string = "TDS_OFF_SELECT";
                break;
            }
            case 335: {
                string = "TDS_OFF_FROM";
                break;
            }
            case 357: {
                string = "TDS_OFF_ORDER";
                break;
            }
            case 313: {
                string = "TDS_OFF_COMPUTE";
                break;
            }
            case 371: {
                string = "TDS_OFF_TABLE";
                break;
            }
            case 362: {
                string = "TDS_OFF_PROC";
                break;
            }
            case 459: {
                string = "TDS_OFF_STMT";
                break;
            }
            case 452: {
                string = "TDS_OFF_PARAM";
                break;
            }
            default: {
                string = "<unrecognized>";
            }
        }
        return string;
    }
}

