/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.RowFormatToken;
import com.sybase.jdbc4.tds.SrvDataFormat;
import com.sybase.jdbc4.tds.SrvFormatToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class SrvRowFormatToken
extends RowFormatToken
implements SrvFormatToken,
Dumpable {
    protected Vector _dataformats = new Vector();
    protected int _len;

    public SrvRowFormatToken(TdsInputStream tdsInputStream) throws IOException, SQLException {
        this._len = (int)this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public SrvRowFormatToken() throws SQLException {
    }

    @Override
    protected void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(238);
        tdsOutputStream.writeShort((int)this.getLength());
        tdsOutputStream.writeShort(this._dataformats.size());
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(i);
            srvDataFormat.send(tdsOutputStream);
        }
    }

    @Override
    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
        }
    }

    @Override
    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvDataFormat(tdsInputStream);
    }

    public long getLength() {
        int n = 2;
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(i);
            n += srvDataFormat.length();
        }
        return n;
    }

    @Override
    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    @Override
    public int getFormatCount() {
        return this._dataformats.size();
    }

    @Override
    public DataFormat formatAt(int n) {
        return (SrvDataFormat)this.getDataFormat(n);
    }

    @Override
    protected DataFormat getDataFormat(int n) {
        return (SrvDataFormat)this._dataformats.elementAt(n);
    }

    @Override
    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(i);
            srvDataFormat.send(tdsOutputStream);
        }
    }

    public int getByteLength(int n) {
        DataFormat dataFormat = this.formatAt(n);
        return SrvDataFormat.lengthSize(dataFormat._datatype);
    }

    public boolean hasKeyColumns() {
        boolean bl = false;
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(i);
            if ((srvDataFormat._status & 2) == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(238)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ROWFMT Token (0x" + HexConverts.hexConvert(238, 1) + ");");
            } else {
                dumpInfo.addInfo("Token", 1, "ROWFMT Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._len);
            }
            dumpInfo.addInt("Number of Columns", 2, this._numColumns);
            for (int i = 0; i < this.getFormatCount(); ++i) {
                dumpInfo.addInfo("TDSFmt", 0, "Column " + (i + 1));
                DataFormat dataFormat = this.formatAt(i);
                ((SrvDataFormat)dataFormat).setParentTokenType(this.getTokenType());
                dumpInfo.addInfo(((SrvDataFormat)dataFormat).dump(dumpFilter));
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 238;
    }
}

