/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.RowToken;
import com.sybase.jdbc4.tds.SrvDataToken;
import com.sybase.jdbc4.tds.SrvFormatToken;
import com.sybase.jdbc4.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc4.tds.SrvTypeFormatter;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;

public class SrvRowToken
extends RowToken
implements SrvDataToken,
Dumpable {
    SrvTypeFormatter _formatter = null;
    TdsInputStream _in = null;

    public SrvRowToken(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
        this._in = tdsInputStream;
    }

    public SrvRowToken() {
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(209);
        this._formatter.sendDataStream(tdsOutputStream);
    }

    @Override
    public void setFormatter(SrvTypeFormatter srvTypeFormatter) {
        this._formatter = srvTypeFormatter;
    }

    @Override
    public TdsInputStream getStream() {
        return this._in;
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        if (this._formatter == null) {
            throw new Error("Ya godda have a formatter to dump rows.");
        }
        DumpInfo dumpInfo = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = (SrvJavaTypeFormatter)this._formatter;
        Object[] objectArray = srvJavaTypeFormatter.convertData(this);
        if (dumpFilter.includesToken(209)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ROW Token (0x" + HexConverts.hexConvert(209, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ROW Token");
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(6)) {
                int[] nArray = srvJavaTypeFormatter.getColumnStatusBytes();
                int[] nArray2 = srvJavaTypeFormatter.getSerializationTypes();
                int[] nArray3 = srvJavaTypeFormatter.getDataLengths();
                int[] nArray4 = srvJavaTypeFormatter.getLengthSizes();
                long[] lArray = srvJavaTypeFormatter.getLobLengths();
                int[] nArray5 = srvJavaTypeFormatter.getLocatorLengths();
                Object[] objectArray2 = srvJavaTypeFormatter.getLocators();
                SrvFormatToken srvFormatToken = srvJavaTypeFormatter.getDataFormats();
                String[] stringArray = new String[]{"DATA_NORMAL", "DATA_NULL", "DATA_ZERO_LENGTH_TEXT_IMAGE", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>"};
                for (int i = 0; i < objectArray.length; ++i) {
                    dumpInfo.addInfo("TDSFmt", 0, "Column " + (i + 1));
                    DataFormat dataFormat = srvFormatToken.formatAt(i);
                    String string = null;
                    if (dataFormat.isUnitype()) {
                        string = this.getStream().getBigEndian() ? "UnicodeBigUnmarked" : "UnicodeLittleUnmarked";
                    }
                    if (dumpFilter.includesDetail(1)) {
                        if (nArray[i] != 9999) {
                            byte by = (byte)nArray[i];
                            dumpInfo.addBitfield("Column Status", 1, by, stringArray);
                            if ((by & 1) != 0) {
                                dumpInfo.addValue("Row data", nArray3[i], objectArray[i], string);
                                continue;
                            }
                        }
                        dumpInfo.addInt("Length", nArray4[i], nArray3[i]);
                    }
                    if (nArray2[i] != 9999) {
                        dumpInfo.addInt("Blob Serialization Type", 1, nArray2[i]);
                    }
                    if (lArray[i] != -999L) {
                        dumpInfo.addInt("Lob Length", 8, lArray[i]);
                    }
                    if (nArray5[i] != -999) {
                        dumpInfo.addInt("Locator Length", 2, nArray5[i]);
                    }
                    if (objectArray2[i] instanceof byte[]) {
                        byte[] byArray = (byte[])objectArray2[i];
                        dumpInfo.addHex("Locator", byArray.length, byArray);
                    }
                    dumpInfo.addValue("Row data", nArray3[i], objectArray[i], string);
                }
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 209;
    }
}

