/*
 * Decompiled with CFR 0.152.
 */
package toys.timberix.lexerix.api.inventory_management;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ResultRow;
import toys.timberix.lexerix.api.inventory_management.PriceMatrix;
import toys.timberix.lexerix.api.utils.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\tJ\u0006\u0010\u001d\u001a\u00020\tJ\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Ltoys/timberix/lexerix/api/inventory_management/OrderContentData;", "", "product", "Lorg/jetbrains/exposed/sql/ResultRow;", "count", "", "note", "", "netPriceOverride", "Ljava/math/BigDecimal;", "(Lorg/jetbrains/exposed/sql/ResultRow;ILjava/lang/String;Ljava/math/BigDecimal;)V", "getCount", "()I", "getNetPriceOverride", "()Ljava/math/BigDecimal;", "getNote", "()Ljava/lang/String;", "getProduct", "()Lorg/jetbrains/exposed/sql/ResultRow;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "netPrice", "netPricePerPiece", "toString", "lexerix"})
public final class OrderContentData {
    @NotNull
    private final ResultRow product;
    private final int count;
    @NotNull
    private final String note;
    @Nullable
    private final BigDecimal netPriceOverride;

    public OrderContentData(@NotNull ResultRow product, int count, @NotNull String note, @Nullable BigDecimal netPriceOverride) {
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        this.product = product;
        this.count = count;
        this.note = note;
        this.netPriceOverride = netPriceOverride;
    }

    public /* synthetic */ OrderContentData(ResultRow resultRow, int n, String string, BigDecimal bigDecimal, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string = "";
        }
        if ((n2 & 8) != 0) {
            bigDecimal = null;
        }
        this(resultRow, n, string, bigDecimal);
    }

    @NotNull
    public final ResultRow getProduct() {
        return this.product;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final String getNote() {
        return this.note;
    }

    @Nullable
    public final BigDecimal getNetPriceOverride() {
        return this.netPriceOverride;
    }

    @NotNull
    public final BigDecimal netPrice() {
        BigDecimal bigDecimal = this.netPricePerPiece().multiply(new BigDecimal(this.count));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
        return bigDecimal;
    }

    @NotNull
    public final BigDecimal netPricePerPiece() {
        BigDecimal bigDecimal = this.netPriceOverride;
        if (bigDecimal == null) {
            bigDecimal = UtilsKt.asCurrency(((Number)this.product.get((Expression)PriceMatrix.INSTANCE.getSellingPrice())).floatValue());
        }
        return bigDecimal;
    }

    @NotNull
    public final ResultRow component1() {
        return this.product;
    }

    public final int component2() {
        return this.count;
    }

    @NotNull
    public final String component3() {
        return this.note;
    }

    @Nullable
    public final BigDecimal component4() {
        return this.netPriceOverride;
    }

    @NotNull
    public final OrderContentData copy(@NotNull ResultRow product, int count, @NotNull String note, @Nullable BigDecimal netPriceOverride) {
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        return new OrderContentData(product, count, note, netPriceOverride);
    }

    public static /* synthetic */ OrderContentData copy$default(OrderContentData orderContentData, ResultRow resultRow, int n, String string, BigDecimal bigDecimal, int n2, Object object) {
        if ((n2 & 1) != 0) {
            resultRow = orderContentData.product;
        }
        if ((n2 & 2) != 0) {
            n = orderContentData.count;
        }
        if ((n2 & 4) != 0) {
            string = orderContentData.note;
        }
        if ((n2 & 8) != 0) {
            bigDecimal = orderContentData.netPriceOverride;
        }
        return orderContentData.copy(resultRow, n, string, bigDecimal);
    }

    @NotNull
    public String toString() {
        return "OrderContentData(product=" + this.product + ", count=" + this.count + ", note=" + this.note + ", netPriceOverride=" + this.netPriceOverride + ")";
    }

    public int hashCode() {
        int result = this.product.hashCode();
        result = result * 31 + Integer.hashCode(this.count);
        result = result * 31 + this.note.hashCode();
        result = result * 31 + (this.netPriceOverride == null ? 0 : this.netPriceOverride.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrderContentData)) {
            return false;
        }
        OrderContentData orderContentData = (OrderContentData)other;
        if (!Intrinsics.areEqual((Object)this.product, (Object)orderContentData.product)) {
            return false;
        }
        if (this.count != orderContentData.count) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.note, (Object)orderContentData.note)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.netPriceOverride, (Object)orderContentData.netPriceOverride);
    }
}

