/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.tranql.connector.DissociatableConnectionHandle;
import org.tranql.connector.DissociatableConnectionHandleFactory;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordHandleFactoryRequestInfo;

public abstract class AbstractManagedConnection
implements ManagedConnection,
ManagedConnectionHandle,
DissociatableManagedConnection {
    protected final ManagedConnectionFactory mcf;
    protected final Object physicalConnection;
    protected final LinkedList handles = new LinkedList();
    protected final ArrayList listeners = new ArrayList(2);
    private final ExceptionSorter exceptionSorter;
    protected PrintWriter log;
    protected Subject subject;
    protected ConnectionRequestInfo cri;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractManagedConnection(ManagedConnectionFactory mcf, Object physicalConnection, ExceptionSorter exceptionSorter) {
        if (!$assertionsDisabled && exceptionSorter == null) {
            throw new AssertionError();
        }
        this.mcf = mcf;
        this.physicalConnection = physicalConnection;
        this.exceptionSorter = exceptionSorter;
    }

    public Object getPhysicalConnection() {
        return this.physicalConnection;
    }

    public void cleanup() throws ResourceException {
        this.dissociateConnections();
    }

    public void destroy() throws ResourceException {
        this.dissociateConnections();
        this.listeners.clear();
        this.closePhysicalConnection();
    }

    protected abstract void closePhysicalConnection() throws ResourceException;

    public void associateConnection(Object o) throws ResourceException {
        if (!$assertionsDisabled && !(o instanceof DissociatableConnectionHandle)) {
            throw new AssertionError((Object)("Attempt to associate incompatible handle: " + o));
        }
        DissociatableConnectionHandle handle = (DissociatableConnectionHandle)o;
        ManagedConnectionHandle mc = handle.getAssociation();
        if (mc instanceof AbstractManagedConnection) {
            ((AbstractManagedConnection)mc).handles.remove(handle);
        }
        handle.setAssociation(this);
        this.handles.add(handle);
    }

    public void dissociateConnections() throws ResourceException {
        while (!this.handles.isEmpty()) {
            DissociatableConnectionHandle handle = (DissociatableConnectionHandle)this.handles.removeFirst();
            handle.setAssociation(null);
        }
    }

    public void connectionClosed(Object handle) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle(handle);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.connectionClosed(event);
        }
    }

    public void connectionError(Exception e) {
        if (this.exceptionSorter.isExceptionFatal(e)) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, e);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
                listener.connectionErrorOccurred(event);
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.log;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.log = printWriter;
    }

    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
                listener.localTransactionStarted(event);
            }
        }
    }

    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
                listener.localTransactionCommitted(event);
            }
        }
    }

    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
                listener.localTransactionRolledback(event);
            }
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        DissociatableConnectionHandleFactory handleFactory = ((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getConnectionHandleFactory();
        DissociatableConnectionHandle handle = handleFactory.newHandle(connectionRequestInfo);
        handle.setAssociation(this);
        this.handles.add(handle);
        this.subject = subject;
        this.cri = connectionRequestInfo;
        return handle;
    }

    static {
        $assertionsDisabled = !AbstractManagedConnection.class.desiredAssertionStatus();
    }

    protected class LocalTransactionImpl
    implements LocalTransaction {
        private final boolean isSPI;

        public LocalTransactionImpl(boolean isSPI) {
            this.isSPI = isSPI;
        }

        public void begin() throws ResourceException {
            AbstractManagedConnection.this.localTransactionStart(this.isSPI);
        }

        public void commit() throws ResourceException {
            AbstractManagedConnection.this.localTransactionCommit(this.isSPI);
        }

        public void rollback() throws ResourceException {
            AbstractManagedConnection.this.localTransactionRollback(this.isSPI);
        }
    }
}

