/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.PrintWriter;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import org.tranql.connector.AllExceptionsAreFatalSorter;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.NoExceptionsAreFatalSorter;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.DataSource;
import org.tranql.connector.jdbc.ManagedJDBCConnection;

public class JDBCDriverMCF
implements UserPasswordManagedConnectionFactory {
    private String driver;
    private String url;
    private String user;
    private String password;
    private ExceptionSorter exceptionSorter = new AllExceptionsAreFatalSorter();
    private Boolean commitBeforeAutocommit = Boolean.FALSE;
    private PrintWriter log;

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("ConnectionManager is required");
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new DataSource(this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        Object sqlConnection = this.getPhysicalConnection(subject, credentialExtractor);
        return new ManagedJDBCConnection(this, sqlConnection, credentialExtractor, this.exceptionSorter);
    }

    protected Object getPhysicalConnection(Subject subject, CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            String password;
            Driver jdbcDriver = this.getJDBCDriver();
            if (!jdbcDriver.acceptsURL(this.url)) {
                throw new ResourceAdapterInternalException("JDBC Driver cannot handle url: " + this.url);
            }
            Properties info = new Properties();
            String user = credentialExtractor.getUserName();
            if (user != null) {
                info.setProperty("user", user);
            }
            if ((password = credentialExtractor.getPassword()) != null) {
                info.setProperty("password", password);
            }
            return jdbcDriver.connect(this.url, info);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.url, (Throwable)e);
        }
    }

    private Driver getJDBCDriver() throws ResourceAdapterInternalException {
        try {
            Class<?> driverClass = Thread.currentThread().getContextClassLoader().loadClass(this.driver);
            return (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ResourceAdapterInternalException("Unable to load driver class: " + this.driver, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ResourceAdapterInternalException("Unable to instantiate driver class: " + this.driver, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceAdapterInternalException("Unable to instantiate driver class: " + this.driver, (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            ManagedConnectionHandle mc;
            Object o = i.next();
            if (!(o instanceof ManagedConnectionHandle) || !(mc = (ManagedConnectionHandle)o).matches(this, subject, connectionRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public void setLogWriter(PrintWriter log) {
        this.log = log;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getConnectionURL() {
        return this.url;
    }

    public void setConnectionURL(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.user;
    }

    public void setUserName(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean isCommitBeforeAutocommit() {
        return this.commitBeforeAutocommit;
    }

    public void setCommitBeforeAutocommit(Boolean commitBeforeAutocommit) {
        this.commitBeforeAutocommit = commitBeforeAutocommit;
    }

    public String getExceptionSorterClass() {
        return this.exceptionSorter.getClass().getName();
    }

    public void setExceptionSorterClass(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.exceptionSorter = new NoExceptionsAreFatalSorter();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JDBCDriverMCF) {
            JDBCDriverMCF other = (JDBCDriverMCF)obj;
            return this.url == other.url || this.url != null && this.url.equals(other.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url == null ? 0 : this.url.hashCode();
    }

    public String toString() {
        return "JDBCDriverMCF[" + this.user + "@" + this.url + "]";
    }
}

