/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.tranql.connector.AllExceptionsAreFatalSorter;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.DataSource;
import org.tranql.connector.jdbc.ManagedXAConnection;

public abstract class AbstractXADataSourceMCF
implements UserPasswordManagedConnectionFactory {
    protected final XADataSource xaDataSource;
    private PrintWriter log;
    private ExceptionSorter exceptionSorter = new AllExceptionsAreFatalSorter();
    private Boolean commitBeforeAutocommit = Boolean.FALSE;

    protected AbstractXADataSourceMCF(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("ConnectionManager is required");
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new DataSource(this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        XAConnection sqlConnection = this.getPhysicalConnection(subject, credentialExtractor);
        try {
            return new ManagedXAConnection(this, sqlConnection, credentialExtractor, this.exceptionSorter);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Could not set up ManagedXAConnection", (Throwable)e);
        }
    }

    protected XAConnection getPhysicalConnection(Subject subject, CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            return this.xaDataSource.getXAConnection(credentialExtractor.getUserName(), credentialExtractor.getPassword());
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.xaDataSource, (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            ManagedConnectionHandle mc;
            Object o = i.next();
            if (!(o instanceof ManagedConnectionHandle) || !(mc = (ManagedConnectionHandle)o).matches(this, subject, connectionRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public Boolean isCommitBeforeAutocommit() {
        return this.commitBeforeAutocommit;
    }

    public void setCommitBeforeAutocommit(Boolean commitBeforeAutocommit) {
        this.commitBeforeAutocommit = commitBeforeAutocommit;
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public void setLogWriter(PrintWriter log) {
        this.log = log;
    }

    public String getExceptionSorterClass() {
        return this.exceptionSorter.getClass().getName();
    }

    public void setExceptionSorterClass(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.exceptionSorter = className != null && !className.equals("") ? (ExceptionSorter)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance() : new AllExceptionsAreFatalSorter();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractXADataSourceMCF) {
            AbstractXADataSourceMCF other = (AbstractXADataSourceMCF)obj;
            return this.xaDataSource.equals(other.xaDataSource);
        }
        return false;
    }

    public int hashCode() {
        return this.xaDataSource.hashCode();
    }

    public String toString() {
        return "AbstractXADataSourceMCF[" + this.xaDataSource + "]";
    }
}

