/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.tranql.connector.DissociatableConnectionHandle;
import org.tranql.connector.DissociatableConnectionHandleFactory;
import org.tranql.connector.NotSupportedException;
import org.tranql.connector.UserPasswordHandleFactoryRequestInfo;
import org.tranql.connector.jdbc.ConnectionHandle;

public class DataSource
implements javax.sql.DataSource,
Referenceable,
javax.resource.Referenceable {
    private final ManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private final UserPasswordHandleFactoryRequestInfo containerRequestInfo;
    private Reference ref;
    private final DissociatableConnectionHandleFactory handleFactory;

    public DataSource(ManagedConnectionFactory mcf, ConnectionManager connectionManager) {
        this.mcf = mcf;
        this.cm = connectionManager;
        this.handleFactory = new HandleFactory(this.cm, mcf);
        this.containerRequestInfo = new UserPasswordHandleFactoryRequestInfo(this.handleFactory, null, null);
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)this.containerRequestInfo);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            UserPasswordHandleFactoryRequestInfo cri = new UserPasswordHandleFactoryRequestInfo(this.handleFactory, user, password);
            return (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)cri);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public PrintWriter getLogWriter() throws SQLException {
        try {
            return this.mcf.getLogWriter();
        }
        catch (ResourceException e) {
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        throw new NotSupportedException("Cannot set loginTimeout on a connection factory");
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new NotSupportedException("Cannot set logWriter on a connection factory");
    }

    public Reference getReference() throws NamingException {
        return this.ref;
    }

    public void setReference(Reference reference) {
        this.ref = reference;
    }

    private static class HandleFactory
    implements DissociatableConnectionHandleFactory {
        private final LazyAssociatableConnectionManager connectionManager;
        private final ManagedConnectionFactory managedConnectionFactory;

        HandleFactory(ConnectionManager connectionManager, ManagedConnectionFactory managedConnectionFactory) {
            this.connectionManager = connectionManager instanceof LazyAssociatableConnectionManager ? (LazyAssociatableConnectionManager)connectionManager : null;
            this.managedConnectionFactory = managedConnectionFactory;
        }

        public DissociatableConnectionHandle newHandle(ConnectionRequestInfo connectionRequestInfo) {
            return new ConnectionHandle(this.connectionManager, this.managedConnectionFactory, connectionRequestInfo);
        }
    }
}

