/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.tranql.connector.jdbc.ConnectionHandle;
import org.tranql.connector.jdbc.ResultSetHandle;

public class StatementHandle
implements Statement {
    protected final ConnectionHandle c;
    protected final Statement s;

    public StatementHandle(ConnectionHandle c, Statement s) {
        this.c = c;
        this.s = s;
    }

    public Connection getConnection() {
        return this.c;
    }

    private ResultSet wrapResultSet(ResultSet rs) {
        return rs == null ? null : new ResultSetHandle(this, rs);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.wrapResultSet(this.s.executeQuery(sql));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.wrapResultSet(this.s.getGeneratedKeys());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            return this.wrapResultSet(this.s.getResultSet());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void addBatch(String sql) throws SQLException {
        try {
            this.s.addBatch(sql);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void cancel() throws SQLException {
        try {
            this.s.cancel();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.s.clearBatch();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.s.clearWarnings();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void close() throws SQLException {
        try {
            this.s.close();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            return this.s.execute(sql);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.s.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.s.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.s.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.s.executeBatch();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            return this.s.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.s.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.s.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.s.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.s.getFetchDirection();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.s.getFetchSize();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.s.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.s.getMaxRows();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.s.getMoreResults();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        try {
            return this.s.getMoreResults(current);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.s.getQueryTimeout();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.s.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.s.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.s.getResultSetType();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.s.getUpdateCount();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.s.getWarnings();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void setCursorName(String name) throws SQLException {
        try {
            this.s.setCursorName(name);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.s.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.s.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            this.s.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.s.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            this.s.setMaxRows(max);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.s.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }
}

